/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: JBIVehicle.java 62592 2011-04-20 20:07:16Z kgrucci $
 */

package com.sun.ts.tests.common.vehicle.jbi;

import com.sun.ts.lib.tests.jbi.*;
import com.sun.ts.lib.harness.*;
import com.sun.ts.lib.util.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.Remote;
import java.rmi.RemoteException;
import com.sun.javatest.Status;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;

public class JBIVehicle extends RemoteComponent implements RemoteComponentInterface {

    private EETest     testObj;
    private Properties p;
    private String[]   arguments = new String[0]; 
    private String     installRoot;

    public JBIVehicle() {
	NAME = getClass().getName();
    }

    // override init from BaseComponent to bind the JBIVehicle
    public void init(ComponentContext arg0) throws JBIException {
	super.init(arg0);
        installRoot = arg0.getInstallRoot();
    }

    public Result invoke(ServiceRequest request) throws RemoteException {
	try {
	    p = request.getProperties();
	    testInit(p);	
	    Class clazz = Class.forName(p.getProperty("test.class"));
	    testObj = (EETest)clazz.newInstance();
	    TestUtil.logTrace("JBIVehicle.invoke");
	} catch (Exception e) {
	    throw new RemoteException("JBIVehicle.invoke() Failed", e);
	}
        return runTest();
    }
    
    public Remote getRemoteObject() {
	return this;
    }

    //the run method that we call here will either throw
    //an exception (failed), or return void (pass)
    private Result runTest() {
	Result result = null;
	Status stat = null;
	TestUtil.logTrace("in runTest()" );
	try {
	    //set component context props so that they are accessible by the test
            p.setProperty("component.install.root", installRoot);   

            //call EETest impl's run method
	    stat = testObj.run(arguments, p);
	    
	    if(stat.getType() == Status.PASSED) {
		TestUtil.logMsg("Test running in JBI vehicle passed");
	    } else {
		TestUtil.logMsg("Test running in JBI vehicle failed");
	    }
	    result = new Result(stat);
	}
	catch(Throwable e) {	
	    e.printStackTrace();
	    TestUtil.logErr("Test running in JBI vehicle failed", e);
	    result = new Result(false, "Test running in JBI vehicle failed" + e.toString());
	}
	return result;
    }
    
}
