/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62536 2011-04-15 16:35:14Z af70133 $
 */
/*************************************************************************
   Licensed Materials - Property of IBM
   WSEE1.0 (C) Copyright International Business Machines Corp. 2002
   All Rights Reserved.
   US Government Users Restricted Rights - Use, duplication or
   disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
**************************************************************************/
/*************************************************************************
   IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
   ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
   PURPOSE. IN NO EVENT SHALL IBM BE LIABLE FOR ANY SPECIAL, INDIRECT OR
   CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
   USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
   OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
   OR PERFORMANCE OF THIS SOFTWARE.
**************************************************************************/

/*
 * @(#)Client.java	1.32	03/05/16
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc_encoding.TypeMappingRegistry;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;
import com.sun.ts.tests.jaxrpc.common.*;
import com.sun.javatest.Status;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;

import javax.xml.rpc.*;
import javax.xml.rpc.encoding.*;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;

public class Client extends ServiceEETest
{

    TypeMappingRegistry registry = null;
    TypeMapping typeMapping = null;

    Service svc = null;

    public void getStub() throws Exception {
      /* Lookup service */
      try {
         InitialContext ic = new InitialContext();
	 TestUtil.logMsg("Obtained InitialContext");
	 TestUtil.logMsg("Lookup java:comp/env/service/typemappingregistry");
         svc = (javax.xml.rpc.Service)ic.lookup("java:comp/env/service/typemappingregistry");
	 TestUtil.logMsg("Obtained service");
      } catch (Throwable t) {
           TestUtil.printStackTrace(t);
           throw new Fault(t.toString());
      }
    }


    public static void main(String[] args)
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }


/*  Test setup */

  /*
     * @class.testArgs:     -ap jaxrpc-url-props.dat
   *   @class.setup_props: webServerHost;
   *                       webServerPort;
   */

    public void setup(String[] args, Properties p) throws Fault
    {

        try {
            getStub();
        } catch (Exception e) {
	     TestUtil.printStackTrace(e);
             throw new Fault("setup failed:", e);
        }
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  GetTypeMappingRegistryTest
     *
     *   @assertion_ids: JAXRPC:JAVADOC:46; WS4EE:SPEC:28;
     *
     *   @test_Strategy: Invoke the getTypeMappingRegistry() method and
     *			 verify that the behavior returns an unsupported
     *		         operations exception
     *	
     */
    public void GetTypeMappingRegistryTest() throws Fault {


	TestUtil.logTrace("GetTypeMappingRegistryTest");
	boolean pass = false;
        try {
	    TestUtil.logMsg("Invoking getTypeMappingRegistry()");
	    registry = svc.getTypeMappingRegistry();
	    TestUtil.logErr("UnsupportedOperationException was not thrown");
        } catch (UnsupportedOperationException e) {
	    TestUtil.logMsg("Caught UnsupportedOperationException");
            pass = true;
        } catch (Exception e) {
            throw new Fault("GetTypeMappingRegistryTest failed with Exception", e);
        }
	if (!pass)
	    throw new Fault("GetTypeMappingRegistryTest failed - !pass");
    }

}
