/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleTestClient.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.sharedclients.simpleclient;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;


public class SimpleTestClient extends SOAPClient {

    public SimpleTestClient(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://simpletestservice.org/wsdl");
        stubContext.setService("SimpleTest");
        stubContext.setPortPrefix("SimpleEndpoint");
        stubContext.setServiceInterface(SimpleEndpoint.class);
    }

    protected String getEndpointURLProperty() {
        return CTSConstants.simpleEndpointProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.simpleWSDLProperty;
    }

    public String helloWorld() throws Exception{
        TestUtil.logMsg("STUB CLASS: " + stubContext.getStub().getClass().getName());
        return ((SimpleEndpoint)stubContext.getStub()).helloWorld();
    }

    public String arrayOperationFromClient(String [] array) throws Exception{
        return ((SimpleEndpoint)stubContext.getStub()).arrayOperationFromClient(new StringArray(array));
    }
}
