/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: W2JRLR1109ClientTwo.java 62536 2011-04-15 16:35:14Z af70133 $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R1109;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.jaxrpc.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxrpc.wsi.constants.CTSConstants;


public class W2JRLR1109ClientTwo extends SOAPClient{

    public W2JRLR1109ClientTwo(String webServerHost, int port, int mode) throws EETest.Fault{
        super(webServerHost, port, mode);
        stubContext.setNamespace("http://soapactionservice.org/wsdl/");
        stubContext.setService("W2JRLR1109TestService");
        stubContext.setPortPrefix("W2JRLR1109TestTwo");
        stubContext.setServiceInterface(W2JRLR1109Test.class);
    }
    protected String getEndpointURLProperty() {
        return CTSConstants.w2jrlr1109EndpointTwoProperty;
    }

    protected String getWSDLURLProperty() {
        return CTSConstants.w2jrlr1109WSDLTwoProperty;
    }

    public String echoString(String s) throws Exception{
        return ((W2JRLR1109Test)stubContext.getStub()).echoString(s);
    }
}
