/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditPane;
import com.sun.javatest.audit.AuditToolManager;
import com.sun.javatest.audit.BadChecksumPane;
import com.sun.javatest.audit.BadTestCaseTestsPane;
import com.sun.javatest.audit.BadTestDescriptionPane;
import com.sun.javatest.audit.BadTestsPane;
import com.sun.javatest.audit.OptionsDialog;
import com.sun.javatest.audit.SummaryPane;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.File;
import java.util.Map;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AuditTool
extends Tool {
    private static int WAIT_DIALOG_DELAY = 2000;
    private JMenuBar menuBar;
    private JTextField testSuiteField;
    private JTextField workDirField;
    private JTextField configFileField;
    private AuditPane[] panes;
    private JTabbedPane tabs;
    private OptionsDialog optionsDialog;
    private boolean autoShowOptions = true;
    private Listener listener = new Listener();
    private InterviewParameters interviewParams;
    private Thread worker;
    private Audit audit;
    private static final String OPTIONS = "options";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(AuditTool.class);

    AuditTool(AuditToolManager m) {
        super(m, "audit", "audit.window.csh");
        this.setI18NTitle("tool.title");
        this.setShortTitle(this.uif.getI18NString("tool.shortTitle"));
        this.initGUI();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.optionsDialog != null) {
            this.optionsDialog.setVisible(false);
            this.optionsDialog.dispose();
        }
    }

    @Override
    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    @Override
    public TestSuite[] getLoadedTestSuites() {
        TestSuite[] testSuiteArray;
        TestSuite ts;
        TestSuite testSuite = ts = this.interviewParams == null ? null : this.interviewParams.getTestSuite();
        if (ts == null) {
            testSuiteArray = null;
        } else {
            TestSuite[] testSuiteArray2 = new TestSuite[1];
            testSuiteArray = testSuiteArray2;
            testSuiteArray2[0] = ts;
        }
        return testSuiteArray;
    }

    @Override
    public WorkDirectory[] getLoadedWorkDirectories() {
        WorkDirectory[] workDirectoryArray;
        WorkDirectory wd;
        WorkDirectory workDirectory = wd = this.interviewParams == null ? null : this.interviewParams.getWorkDirectory();
        if (wd == null) {
            workDirectoryArray = null;
        } else {
            WorkDirectory[] workDirectoryArray2 = new WorkDirectory[1];
            workDirectoryArray = workDirectoryArray2;
            workDirectoryArray2[0] = wd;
        }
        return workDirectoryArray;
    }

    @Override
    public void save(Map m) {
        File cf;
        if (this.interviewParams == null) {
            return;
        }
        TestSuite ts = this.interviewParams.getTestSuite();
        m.put("testSuite", ts.getRoot().getPath());
        WorkDirectory wd = this.interviewParams.getWorkDirectory();
        if (wd != null) {
            m.put("workDir", wd.getPath());
        }
        if ((cf = this.interviewParams.getFile()) != null) {
            m.put("config", cf.getPath());
        }
    }

    @Override
    protected void restore(Map m) {
        String tsp = (String)m.get("testSuite");
        String wdp = (String)m.get("workDir");
        String cfp = (String)m.get("config");
        if (tsp == null && wdp == null && cfp == null) {
            return;
        }
        try {
            if (this.interviewParams != null) {
                this.interviewParams.dispose();
            }
            this.interviewParams = InterviewParameters.open(tsp, wdp, cfp);
            this.updateGUI(null, this.interviewParams, this.uif.getI18NString("tool.restore.txt"));
            this.autoShowOptions = false;
        }
        catch (Interview.Fault e) {
            this.uif.showError("tool.cantRestore", e.getMessage());
        }
    }

    private void initGUI() {
        int dpi = this.uif.getDotsPerInch();
        this.setPreferredSize(new Dimension(6 * dpi, 4 * dpi));
        this.setLayout(new BorderLayout());
        this.addHierarchyListener(this.listener);
        this.menuBar = this.uif.createMenuBar("tool");
        String[] auditMenuEntries = new String[]{OPTIONS};
        JMenu auditMenu = this.uif.createMenu("tool.audit", auditMenuEntries, this.listener);
        this.menuBar.add(auditMenu);
        this.menuBar.add(this.uif.createHorizontalGlue("tool.pad"));
        JMenu helpMenu = this.uif.createMenu("tool.help");
        helpMenu.add(this.uif.createHelpMenuItem("tool.help.window", "audit.window.csh"));
        this.menuBar.add(helpMenu);
        JPanel head = this.uif.createPanel("head", false);
        head.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        head.setLayout(new GridBagLayout());
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.gridwidth = 1;
        lc.insets.right = 5;
        lc.weightx = 0.0;
        GridBagConstraints fc = new GridBagConstraints();
        fc.fill = 2;
        fc.weightx = 1.0;
        fc.gridwidth = 0;
        this.testSuiteField = this.initField("tool.testSuite", head, lc, fc);
        this.workDirField = this.initField("tool.workDir", head, lc, fc);
        this.configFileField = this.initField("tool.configFile", head, lc, fc);
        this.add((Component)head, "North");
        this.panes = new AuditPane[]{new SummaryPane(this.uif), new BadTestsPane(this.uif), new BadChecksumPane(this.uif), new BadTestDescriptionPane(this.uif), new BadTestCaseTestsPane(this.uif)};
        this.tabs = this.uif.createTabbedPane("tool.tabs", this.panes);
        this.tabs.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = AuditTool.this.tabs.getSelectedComponent();
                CSH.setHelpIDString(AuditTool.this.tabs, CSH.getHelpIDString(c));
            }
        });
        CSH.setHelpIDString(this.tabs, CSH.getHelpIDString(this.panes[0]));
        this.add((Component)this.tabs, "Center");
        this.updateGUI(null, null, this.uif.getI18NString("tool.initial.txt"));
    }

    private JTextField initField(String key, JPanel p, GridBagConstraints lc, GridBagConstraints fc) {
        JLabel lbl = this.uif.createLabel(key, true);
        p.add((Component)lbl, lc);
        JTextField tf = this.uif.createOutputField(key, lbl);
        tf.setBorder(null);
        p.add((Component)tf, fc);
        return tf;
    }

    private synchronized void showOptions() {
        if (this.worker != null) {
            this.uif.showError("tool.auditInProgress");
            return;
        }
        if (this.optionsDialog == null) {
            this.optionsDialog = new OptionsDialog(this, this.listener, this.uif);
        }
        if (this.interviewParams != null) {
            this.optionsDialog.setParameters(this.interviewParams);
        }
        this.optionsDialog.setVisible(true);
    }

    private void setOptions() {
        String tsp = this.optionsDialog.getTestSuitePath();
        String wdp = this.optionsDialog.getWorkDirPath();
        String cfp = this.optionsDialog.getConfigFilePath();
        if (AuditTool.isEmpty(tsp) && AuditTool.isEmpty(wdp) && AuditTool.isEmpty(cfp)) {
            this.uif.showError("tool.noOptions");
            return;
        }
        try {
            if (this.interviewParams != null) {
                this.interviewParams.dispose();
            }
            this.interviewParams = InterviewParameters.open(tsp, wdp, cfp);
        }
        catch (Interview.Fault e) {
            this.uif.showError("tool.badOptions", e.getMessage());
            return;
        }
        this.optionsDialog.setVisible(false);
        this.startAudit();
    }

    private synchronized void startAudit() {
        if (this.worker != null) {
            this.uif.showError("tool.auditInProgress");
            return;
        }
        if (this.interviewParams.getWorkDirectory() == null) {
            this.uif.showError("tool.noWd");
            return;
        }
        final JDialog d = this.uif.createWaitDialog("tool.wait", this);
        d.setLocationRelativeTo(this);
        this.worker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Audit a = AuditTool.this.audit;
                try {
                    a = new Audit(AuditTool.this.interviewParams);
                }
                finally {
                    AuditTool auditTool = AuditTool.this;
                    synchronized (auditTool) {
                        AuditTool.this.worker = null;
                    }
                    d.setVisible(false);
                    AuditTool.this.updateGUI(a, AuditTool.this.interviewParams, null);
                }
            }
        };
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AuditTool.this.worker != null && AuditTool.this.worker.isAlive()) {
                    d.setVisible(true);
                }
            }
        };
        Timer timer = new Timer(WAIT_DIALOG_DELAY, al);
        timer.setRepeats(false);
        timer.start();
        this.worker.start();
        this.updateGUI(null, this.interviewParams, "");
    }

    private void updateGUI(final Audit a, final InterviewParameters p, final String msg) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuditTool.this.updateGUI(a, p, msg);
                }
            });
            return;
        }
        this.audit = a;
        TestSuite ts = p == null ? null : p.getTestSuite();
        String tsp = ts == null ? "" : ts.getPath();
        this.testSuiteField.setText(tsp);
        WorkDirectory wd = p == null ? null : p.getWorkDirectory();
        String wdp = wd == null ? "" : wd.getPath();
        this.workDirField.setText(wdp);
        File configFile = p == null ? null : p.getFile();
        String cfp = configFile == null ? "" : configFile.getPath();
        this.configFileField.setText(cfp);
        for (int i = 0; i < this.panes.length; ++i) {
            AuditPane pane = this.panes[i];
            if (a != null) {
                pane.show(a);
                continue;
            }
            if (msg == null) continue;
            pane.show(msg);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private class Listener
    implements ActionListener,
    HierarchyListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(AuditTool.OPTIONS)) {
                AuditTool.this.showOptions();
            } else if (cmd.equals("OK")) {
                AuditTool.this.setOptions();
            }
        }

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            if (AuditTool.this.isShowing() && AuditTool.this.autoShowOptions) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AuditTool.this.showOptions();
                    }
                });
                AuditTool.this.autoShowOptions = false;
            }
        }
    }
}

