/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: ResponseTemplateFilter.java 69536 2013-01-16 13:41:41Z supol $ 
 */
package com.sun.ts.tests.jaxrs.ee.rs.container.requestcontext.illegalstate;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response.Status;

public class ResponseTemplateFilter extends TemplateFilter implements
		ContainerResponseFilter {

	protected ContainerResponseContext responseContext;

	@Override
	public void filter(ContainerRequestContext requestContext,
			ContainerResponseContext responseContext) throws IOException {
		this.responseContext = responseContext;
		this.requestContext = requestContext;
		String operation = requestContext.getHeaderString(OPERATION);
		Method[] methods = getClass().getMethods();
		for (Method method : methods)
			if (operation.equalsIgnoreCase(method.getName())) {
				try {
					method.invoke(this);
					return;
				} catch (Exception e) {
					e.printStackTrace();
					setEntity(e.getMessage());
					responseContext.setStatus(Status.SERVICE_UNAVAILABLE
							.getStatusCode());
				}
			}
		// When method not found, it is request context operation
	}

	@Override
	protected void setEntity(String entity) {
		responseContext.setEntity(entity, (Annotation[]) null,
				MediaType.WILDCARD_TYPE);
	}

}
