/*
 * Copyright (c) 2012, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id: Resource.java 69831 2013-02-05 18:09:36Z supol $
 */

package com.sun.ts.tests.jaxrs.ee.rs.ext.interceptor.containerreader.interceptorcontext;

import java.io.IOException;
import java.io.InputStreamReader;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.ws.rs.POST;
import javax.ws.rs.Path;

import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;

@Path("resource")
public class Resource {

	@POST
	@Path("string")
	public String post(@NotNull @Size(min=2) String entity) {
		return entity;
	}
	
	@POST
	@Path("inputstreamreader")
	public String post(InputStreamReader reader) throws IOException {
		String entity = JaxrsUtil.readFromReader(reader);
		reader.close();
		return entity;
	}

}
