/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id: AddDynamicFeature.java 69718 2013-01-31 11:55:55Z supol $  
 */

package com.sun.ts.tests.jaxrs.spec.filter.dynamicfeature;

import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class AddDynamicFeature implements DynamicFeature {

	@Override
	public void configure(ResourceInfo resourceInfo, FeatureContext context) {
		if (resourceInfo.getResourceMethod().getName().equals("echo")) {
			context.register(AddTenFilter.class);
			context.register(AddOneInterceptor.class);
		}
	}

}
