/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.reader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(MediaType.APPLICATION_OCTET_STREAM)
public class AppOctetReader extends AbstractReader implements MessageBodyReader<EntityForReader> {

	@Override
	public boolean isReadable(Class<?> type, Type genericType,
			Annotation[] annotations, MediaType mediaType) {
		AbstractReader.readerSet.append(getClass().getSimpleName());
		return MediaType.APPLICATION_OCTET_STREAM_TYPE.equals(mediaType);
	}

	@Override
	public EntityForReader readFrom(Class<EntityForReader> type,
			Type genericType, Annotation[] annotations, MediaType mediaType,
			MultivaluedMap<String, String> httpHeaders, InputStream entityStream)
			throws IOException, WebApplicationException {
		return super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
	}

}
