/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 * 
 * $Id$  
 */

package com.sun.ts.tests.jaxrs.spec.provider.reader;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Path("resource")
public class Resource {
	@Context
	HttpHeaders headers;

	@Path("plain")
	@POST
	public String plain(EntityForReader efr) {
		AbstractReader.resetSet();
		return efr.toString() + ";"
				+ headers.getHeaderString(HttpHeaders.CONTENT_TYPE);
	}
	
	@Path("appjava")
	@POST
	public Response enableAppJava(boolean enable){
		AppJavaReader.setWritable(enable);
		AbstractReader.resetSet();
		return Response.ok().build();
	}
}
