/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * @(#)JAXRClient.java	1.4 03/05/16
 */

/*
 * @(#)JAXRClient.java	1.12 02/07/09
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.RegistryException;
import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;
import com.sun.ts.tests.jaxr.common.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;
import com.sun.javatest.Status;

import javax.xml.registry.*;
import javax.xml.registry.infomodel.*;
import java.net.PasswordAuthentication;
public class JAXRClient extends JAXRCommonClient
{

// ================================================
    com.sun.ts.tests.jaxr.common.JAXR_Util util = null;

    public static void main(String[] args)
    {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }
/*  Test setup */
  /*
   *   @class.setup_props: jaxrPassword;
   *                       jaxrUser;
   *                       jaxrPassword2;
   *                       jaxrUser2;
   *                       registryURL;
   *                       queryManagerURL;
   *                       authenticationMethod;
   *                       providerCapability;
   *                       jaxrConnectionFactoryLookup;
   *                       jaxrSecurityCredentialType;
   *                       jaxrJNDIResource;
   *                       jaxrAlias;
   *                       jaxrAlias2;
   *                       jaxrAliasPassword;
   *                       jaxrAlias2Password;
   */
    public void setup(String[] args, Properties p) throws Fault
    {
       try {
           super.setup(args, p );

         } catch (Exception e) {
            throw new Fault("setup failed:", e);
         }
    }

    public void cleanup()  throws Fault {
        try {
            super.cleanup(); // close connection
         }catch (Exception e) {
            TestUtil.logErr("Cleanup error: " +
                                e.toString());
            TestUtil.printStackTrace(e);
        }finally {
              // print out messages
              if ( debug != null)
                    TestUtil.logTrace(debug.toString());
        }
    }
   /*
     *   @testName: registryException_ConstructorTest1
     *
     *
     *   @assertion_ids: JAXR:JAVADOC:13;
     *
     *   @assertion:  RegistryException -
     *                    Constructs a JAXRException object with no reason or embedded Throwable
     *
     *   @test_Strategy: Create and verify RegistryException
     *
     */
    public void registryException_ConstructorTest1() throws Fault {
        String testName = "registryException_ConstructorTest1()";
        try {
           debug.add("Create and verify a RegistryException instance\n"); 
           RegistryException e = new RegistryException();
           if ( !(e instanceof RegistryException) )
              throw new Fault(testName + "failed to create RegistryException instance");
           else debug.add("RegistryException created successfully\n");
        } catch (Exception ue) {
               TestUtil.logErr("Caught unexpected exception: " + ue.getMessage());
               TestUtil.printStackTrace(ue);
               throw new Fault(testName + "failed", ue);
        }
    } // end of test method

   /*
    *   @testName: registryException_ConstructorTest2
    *
    *
    *   @assertion_ids: JAXR:JAVADOC:14;
    *
    *   @assertion:  RegistryException(reason)  -
    *                    Constructs a JAXRException object with the given String
    *                    as the reason for the exception being thrown
    *
    *   @test_Strategy: Create and verify RegistryException, verify reason.
    *
    */
    public void registryException_ConstructorTest2() throws Fault {
        String testName = "registryException_ConstructorTest2";
        String reason = "test reason";
        boolean pass = true;
        try {
           debug.add("Create and verify a RegistryException(reason)\n"); 
           RegistryException e = new RegistryException(reason);
           if ( !(e instanceof RegistryException ) ){ 
              pass = false;
              debug.add(testName + " failed to create RegistryException instance\n");
           }
           else debug.add("RegistryException created successfully\n");

           if ( ! ( e.getMessage().equals(reason) )) { 
              pass = false;
              debug.add(testName + " failed to return correct reason\n");
           }
           else debug.add("RegistryException returned reason successfully\n");

        } catch (Exception ue) {
               TestUtil.logErr("Caught unexpected exception: " + ue.getMessage());
               TestUtil.printStackTrace(ue);
               throw new Fault(testName + "failed", ue);
        }
        if (!pass)
            throw new Fault(testName + " failed");
    } // end of test method

   /*
    *   @testName: registryException_ConstructorTest3
    *
    *
    *   @assertion_ids: JAXR:JAVADOC:15;
    *
    *   @assertion:  RegistryException(reason, cause)  -
    *                    Constructs a JAXRException object with the given String
    *                    as the reason for the exception being thrown
    *                    and the given Throwable object as an embedded Throwable.
    *
    *   @test_Strategy: Create and verify RegistryException, verify reason and cause.
    *
    */
    public void registryException_ConstructorTest3() throws Fault {
        String testName = "registryException_ConstructorTest3()";
        String reason = "test reason";
        String cause  = "test cause";
        boolean pass = true;
        try {
           Throwable tCause = new Throwable(cause);
           debug.add("Create and verify a RegistryException(reason,cause)\n");
           RegistryException e = new RegistryException(reason, tCause);
           if ( !(e instanceof RegistryException) ) { 
              pass = false;
              debug.add(testName + " failed to create RegistryException instance\n");
           }
           else debug.add("RegistryException created successfully\n");
           if ( ! ( e.getMessage().equals(reason) )) { 
              pass = false;
              debug.add(testName + " failed to return correct reason\n");
           }
           else debug.add("RegistryException returned reason successfully\n");
           Throwable t = e.getCause();
           debug.add("Cause is: " + t.getMessage() + "\n");
           if ( ! (t.getMessage().equals(cause) ) ){
              pass = false; 
              debug.add(testName + " failed to return valid Throwable\n");
           }
        } catch (Exception ue) {
               TestUtil.logErr("Caught unexpected exception: " + ue.getMessage());
               TestUtil.printStackTrace(ue);
               throw new Fault(testName + " failed", ue);
        }
        if (!pass)
            throw new Fault(testName + " failed");

    } // end of test method

   /*
    *   @testName: registryException_ConstructorTest4
    *
    *
    *   @assertion_ids: JAXR:JAVADOC:16;
    *
    *   @assertion:  RegistryException(cause)  -
    *                    Constructs a JAXRException object initialized 
    *                    with the given Exception object.
    *
    *   @test_Strategy: Create and verify RegistryException, verify cause.
    *
    */
    public void registryException_ConstructorTest4() throws Fault {
        String testName = "registryException_ConstructorTest4";
        String cause  = "test cause";
        boolean pass = true;
        try {
           Throwable tCause = new Throwable(cause);
           debug.add("Create and verify a RegistryException(cause)\n");
           RegistryException e = new RegistryException(tCause);
           if ( !(e instanceof RegistryException) ) {
              pass = false;
              debug.add(testName + "failed to create  RegistryException instance\n");
           }
           else debug.add("RegistryException created successfully\n");

           Throwable t = e.getCause();
           debug.add("Cause is: " + t.getMessage() + "\n");
           if ( ! (t.getMessage().equals(cause) ) ) {
              pass = false; 
              debug.add(testName + " failed to return valid Throwable\n");
           }
        } catch (Exception ue) {
               TestUtil.logErr("Caught unexpected exception: " + ue.getMessage());
               TestUtil.printStackTrace(ue);
               throw new Fault(testName + "failed", ue);
        }
        if (!pass)
            throw new Fault(testName + " failed");

    } // end of test method

   /*
     *   @testName: registryException_setGetErrorObjectKeyTest
     *
     *
     *   @assertion_ids: JAXR:JAVADOC:17; JAXR:JAVADOC:19;
     *
     *   @assertion:  Key getErrorObjectKey -
     *                setErrorObjectKey(Key)
     *
     *   @test_Strategy: Set ErrorObjectKey and verify with getErrorObjectKey.
     *
     */
    public void registryException_setGetErrorObjectKeyTest() throws Fault {
        String testName = "registryException_setGetErrorObjectKeyTest";
        String keyId = "uuid:C0B9FE13-179F-413D-8A5B-5004DB8E5BB2";
        boolean pass = true;
        try {
           debug.add("Set ErrorObjectKey and verify with getErrorObjectKey\n");
           Key key = blm.createKey(keyId);
           RegistryException e = new RegistryException();
           if ( !(e instanceof RegistryException) ) {
              pass = false;
              debug.add(testName + "failed to create RegistryException instance\n");
           }
           else debug.add("RegistryException created successfully\n");
           e.setErrorObjectKey(key);
           if ( !( e.getErrorObjectKey().getId().equals(keyId) )) {
              pass = false;
              debug.add(testName + "failed to return ErrorObjectKey\n");
           }
           else debug.add("ErrorObjectKey returned successfully\n");

        } catch (Exception ue) {
               TestUtil.logErr("Caught unexpected exception: " + ue.getMessage());
               TestUtil.printStackTrace(ue);
               throw new Fault(testName + "failed", ue);
        }
        if (!pass)
            throw new Fault(testName + " failed");

    } // end of test method

} // end of class

