/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.Command;
import com.sun.javatest.Status;
import com.sun.javatest.agent.ActiveAgentPool;
import com.sun.javatest.agent.AgentManager;
import java.io.IOException;
import java.io.PrintWriter;

public class ActiveAgentCommand
extends Command {
    public Status run(String[] args, PrintWriter err, PrintWriter out) {
        int i;
        String classPath = null;
        String tag = null;
        boolean localizeArgs = false;
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            if ((args[i].equals("-cp") || args[i].equals("-classpath")) && i + 1 < args.length) {
                classPath = args[++i];
                continue;
            }
            if (args[i].equals("-m") || args[i].equals("-mapArgs")) {
                localizeArgs = true;
                continue;
            }
            if ((args[i].equals("-t") || args[i].equals("-tag")) && i + 1 < args.length) {
                tag = args[++i];
                continue;
            }
            return Status.error("Unrecognized option: " + args[i]);
        }
        if (i == args.length) {
            return Status.error("No command specified");
        }
        String cmdClass = args[i++];
        String[] cmdArgs = new String[args.length - i];
        System.arraycopy(args, i, cmdArgs, 0, cmdArgs.length);
        if (tag == null) {
            tag = cmdClass;
        }
        try {
            AgentManager mgr = AgentManager.access();
            AgentManager.Task t = mgr.connectToActiveAgent();
            if (classPath != null) {
                t.setClassPath(classPath);
            }
            out.println("Executing command via " + t.getConnection().getName());
            return t.executeCommand(tag, cmdClass, cmdArgs, localizeArgs, err, out);
        }
        catch (InterruptedException e) {
            return Status.error("Interrupted while waiting for agent");
        }
        catch (IOException e) {
            return Status.error("Error accessing agent: " + e);
        }
        catch (ActiveAgentPool.NoAgentException e) {
            return Status.error("No agents available for use: " + e.getMessage());
        }
    }
}

