/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.tool;

import com.sun.javatest.tool.DeskView;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Preferences;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.UIFactory;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public abstract class ToolDialog {
    protected final Component parent;
    protected final UIFactory uif;
    protected Tool tool;
    private String uiKey;
    private Tool.Observer defaultDisposeHandler;
    private Container dialog;
    private String title;
    private JMenuBar menuBar;
    private Container main;
    private Container body;
    private JButton[] buttons;
    private JButton cancelButton;
    private JButton defaultButton;
    private String helpID;
    private ComponentListener componentListener;
    private int defaultCloseOperation = 1;
    private Restorer restorer = new Restorer();
    private int type;
    public static final int DIALOG = 0;
    public static final int FRAME = 1;
    public static final int FREE = 16;
    public static final int MODAL = 256;
    public static final int MODAL_DOCUMENT = 4352;
    public static final int MODAL_APPLICATION = 65792;
    public static final int MODAL_TOOLKIT = 69888;

    protected ToolDialog(Component parent, UIFactory uif, String uiKey) {
        this(parent, uif, uiKey, 0);
    }

    protected ToolDialog(Component parent, UIFactory uif, String uiKey, int type) {
        if (parent == null || uif == null || uiKey == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
        this.uif = uif;
        this.uiKey = uiKey;
        this.type = type;
        this.setTool(parent);
    }

    public void setTool(Component parent) {
        Tool t = (Tool)(parent instanceof Tool ? parent : SwingUtilities.getAncestorOfClass(Tool.class, parent));
        if (t != null) {
            this.setTool(t);
        }
    }

    protected void setTool(Tool t) throws IllegalStateException {
        if (t == null || this.tool != null) {
            throw new IllegalStateException();
        }
        this.tool = t;
        this.tool.addToolDialog(this);
        if (this.defaultDisposeHandler != null) {
            this.tool.removeObserver(this.defaultDisposeHandler);
        }
        this.defaultDisposeHandler = new Tool.Observer(){

            @Override
            public void titleChanged(Tool source, String newValue) {
            }

            @Override
            public void shortTitleChanged(Tool source, String newValue) {
            }

            @Override
            public void toolDisposed(Tool source) {
                ToolDialog.this.closing();
            }
        };
        this.tool.addObserver(this.defaultDisposeHandler);
    }

    public Tool getTool() {
        return this.tool;
    }

    public boolean isShowing() {
        return this.dialog != null && this.dialog.isShowing();
    }

    public boolean isVisible() {
        return this.dialog != null && this.dialog.isVisible();
    }

    public void pack() {
        if (this.dialog == null) {
            this.ensureDialogInitialized();
        }
        if (this.dialog instanceof Window) {
            ((Window)this.dialog).pack();
        } else {
            ((JInternalFrame)this.dialog).pack();
        }
    }

    public void setVisible(boolean b) {
        if (b) {
            this.ensureDialogInitialized();
            this.restorer.restore();
            if (this.dialog instanceof Window) {
                ((Window)this.dialog).toFront();
                ((Window)this.dialog).pack();
            } else {
                ((JInternalFrame)this.dialog).toFront();
                ((JInternalFrame)this.dialog).pack();
            }
            this.dialog.setVisible(true);
        } else if (this.dialog != null) {
            this.restorer.save();
            this.dialog.setVisible(false);
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.restorer.save();
            if (this.dialog instanceof Window) {
                ((Window)this.dialog).dispose();
            } else {
                ((JInternalFrame)this.dialog).dispose();
            }
            RootPaneContainer rpc = (RootPaneContainer)((Object)this.dialog);
            rpc.setContentPane(new Container());
            JMenuBar mb = rpc.getRootPane().getJMenuBar();
            if (mb != null) {
                mb.removeAll();
            }
            if (this.componentListener != null && this.dialog != null) {
                this.dialog.removeComponentListener(this.componentListener);
            }
            this.dialog = null;
        }
    }

    public Container getDialogParent() {
        if (this.dialog instanceof Window) {
            return this.dialog;
        }
        return (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.dialog);
    }

    protected abstract void initGUI();

    protected String getTitle() {
        return this.title;
    }

    protected void setI18NTitle(String key) {
        this.setLocalizedTitle(this.uif.getI18NString(key));
    }

    protected void setI18NTitle(String key, Object arg) {
        this.setLocalizedTitle(this.uif.getI18NString(key, arg));
    }

    protected void setI18NTitle(String key, Object[] args) {
        this.setLocalizedTitle(this.uif.getI18NString(key, args));
    }

    private void setContentPane() {
        if (this.dialog != null) {
            this.initMain();
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setContentPane(this.main);
            } else if (this.dialog instanceof JFrame) {
                ((JFrame)this.dialog).setContentPane(this.main);
            } else {
                ((JInternalFrame)this.dialog).setContentPane(this.main);
            }
        }
    }

    private void setLocalizedTitle(String title) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setTitle(title);
            } else if (this.dialog instanceof JFrame) {
                ((JFrame)this.dialog).setTitle(title);
            } else {
                ((JInternalFrame)this.dialog).setTitle(title);
            }
        }
        this.title = title;
    }

    protected void setHelp(String helpID) {
        if (this.dialog != null) {
            this.uif.setHelp(this.dialog, helpID);
        }
        this.helpID = helpID;
    }

    protected JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    protected void setJMenuBar(JMenuBar menuBar) {
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setJMenuBar(menuBar);
            } else if (this.dialog instanceof JFrame) {
                ((JFrame)this.dialog).setJMenuBar(menuBar);
            } else {
                ((JInternalFrame)this.dialog).setJMenuBar(menuBar);
            }
        }
        this.menuBar = menuBar;
    }

    protected Container getBody() {
        return this.body;
    }

    protected void setBody(Container body) {
        this.body = body;
        this.setContentPane();
    }

    protected JButton[] getButtons() {
        return this.buttons;
    }

    protected JButton getDefaultButton() {
        return this.defaultButton;
    }

    protected void setButtons(JButton[] buttons, JButton defaultButton) {
        this.buttons = buttons;
        this.defaultButton = defaultButton;
        this.cancelButton = null;
        if (buttons != null) {
            for (int i = 0; i < buttons.length && this.cancelButton == null; ++i) {
                if (!buttons[i].getActionCommand().equals("cancel")) continue;
                this.cancelButton = buttons[i];
            }
        }
        this.setContentPane();
    }

    protected void setComponentListener(ComponentListener l) {
        this.componentListener = l;
    }

    protected Dimension getSize() {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        return this.dialog.getSize();
    }

    protected void setSize(Dimension d) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setSize(d);
    }

    protected void setSize(int width, int height) {
        if (this.dialog == null) {
            this.ensureDialogInitialized();
        }
        this.dialog.setSize(width, height);
    }

    protected Point getLocation() {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        return this.dialog.getLocation();
    }

    protected void setLocation(Point p) {
        if (this.dialog == null) {
            this.ensureDialogInitialized();
        }
        this.dialog.setLocation(p);
    }

    protected void setLocation(int x, int y) {
        if (this.dialog == null) {
            throw new IllegalStateException();
        }
        this.dialog.setLocation(x, y);
    }

    private void ensureDialogInitialized() {
        Desktop desktop = this.tool.getDesktop();
        if (this.dialog == null || !desktop.isToolOwnerForDialog(this.tool, this.dialog)) {
            if (this.main == null) {
                this.initMain();
            }
            this.initDialog();
        }
    }

    void initDialog() {
        this.initDialog(null, this.isVisible());
    }

    void initDialog(DeskView view, boolean visible) {
        ActionMap actionMap;
        InputMap inputMap;
        JComponent p;
        Window d;
        if (view == null) {
            Desktop desktop = this.tool.getDesktop();
            this.dialog = desktop.createDialog(this.tool, this.uiKey, this.title, this.menuBar, this.main, this.dialog == null ? null : this.dialog.getBounds(), this.type);
        } else {
            this.dialog = view.createDialog(this.tool, this.uiKey, this.title, this.menuBar, this.main, this.dialog == null ? null : this.dialog.getBounds(), this.type);
        }
        if (this.helpID != null) {
            this.uif.setHelp(this.dialog, this.helpID);
        }
        if (this.dialog instanceof JDialog) {
            d = (JDialog)this.dialog;
            if (this.defaultButton != null) {
                ((JDialog)d).getRootPane().setDefaultButton(this.defaultButton);
            }
            d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (ToolDialog.this.defaultButton != null) {
                        ToolDialog.this.defaultButton.requestFocus();
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    ToolDialog.this.windowClosingAction(e);
                }
            });
            ((JDialog)d).setDefaultCloseOperation(this.defaultCloseOperation);
            d.pack();
        } else if (this.dialog instanceof JFrame) {
            d = (JFrame)this.dialog;
            if (this.defaultButton != null) {
                ((JFrame)d).getRootPane().setDefaultButton(this.defaultButton);
            }
            d.addWindowListener(new WindowAdapter(){

                @Override
                public void windowActivated(WindowEvent e) {
                    if (ToolDialog.this.defaultButton != null) {
                        ToolDialog.this.defaultButton.requestFocus();
                    }
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    ToolDialog.this.windowClosingAction(e);
                }
            });
            ((JFrame)d).setDefaultCloseOperation(this.defaultCloseOperation);
            d.pack();
        } else {
            JInternalFrame f = (JInternalFrame)this.dialog;
            if (this.defaultButton != null) {
                f.getRootPane().setDefaultButton(this.defaultButton);
            }
            f.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    ToolDialog.this.windowClosingAction(e);
                }
            });
            f.setDefaultCloseOperation(this.defaultCloseOperation);
            f.pack();
        }
        if (this.componentListener != null) {
            this.dialog.addComponentListener(this.componentListener);
        }
        if (this.cancelButton != null) {
            p = (JPanel)this.main;
            inputMap = p.getInputMap(2);
            actionMap = p.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
            actionMap.put("cancel", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolDialog.this.cancelButton.doClick(250);
                }
            });
        }
        if (this.main instanceof JComponent) {
            p = (JComponent)this.main;
            inputMap = p.getInputMap(2);
            actionMap = p.getActionMap();
            inputMap.put(KeyStroke.getKeyStroke("ctrl 0"), "showInfo");
            actionMap.put("showInfo", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ToolDialog.this.showInfo();
                }
            });
        }
        this.dialog.setVisible(visible);
    }

    protected void setDefaultCloseOperation(int operation) {
        this.defaultCloseOperation = operation;
        if (this.dialog != null) {
            if (this.dialog instanceof JDialog) {
                ((JDialog)this.dialog).setDefaultCloseOperation(operation);
            } else if (this.dialog instanceof JFrame) {
                ((JFrame)this.dialog).setDefaultCloseOperation(operation);
            } else if (this.dialog instanceof JInternalFrame) {
                ((JInternalFrame)this.dialog).setDefaultCloseOperation(operation);
            }
        }
    }

    protected void windowClosingAction(AWTEvent e) {
    }

    protected void disableDefaultDisposeHandler() {
        if (this.defaultDisposeHandler != null) {
            this.tool.removeObserver(this.defaultDisposeHandler);
        }
    }

    private void closing() {
        if (this.dialog instanceof Window) {
            this.dialog.dispatchEvent(new WindowEvent((Window)this.dialog, 201));
        } else if (this.dialog instanceof JInternalFrame) {
            this.dialog.dispatchEvent(new InternalFrameEvent((JInternalFrame)this.dialog, 25550));
        }
        if (this.dialog instanceof JDialog) {
            JDialog d = (JDialog)this.dialog;
            d.dispose();
        } else if (this.dialog instanceof JInternalFrame) {
            JInternalFrame f = (JInternalFrame)this.dialog;
            f.dispose();
        }
    }

    private void initMain() {
        if (this.body == null) {
            this.initGUI();
        }
        if (this.body == null) {
            throw new IllegalStateException();
        }
        if (this.buttons == null || this.buttons.length == 0) {
            this.main = this.body;
        } else {
            int i;
            JPanel m = this.uif.createPanel(this.uiKey + ".main", false);
            m.setLayout(new BorderLayout());
            m.add((Component)this.body, "Center");
            Dimension maxBtnDims = new Dimension();
            for (i = 0; i < this.buttons.length; ++i) {
                Dimension d = this.buttons[i].getPreferredSize();
                maxBtnDims.width = Math.max(maxBtnDims.width, d.width);
                maxBtnDims.height = Math.max(maxBtnDims.height, d.height);
            }
            for (i = 0; i < this.buttons.length; ++i) {
                this.buttons[i].setPreferredSize(maxBtnDims);
            }
            JPanel p = this.uif.createPanel(this.uiKey + ".btns", false);
            p.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 13;
            c.insets.top = 5;
            c.insets.bottom = 11;
            c.insets.right = 11;
            c.weightx = 1.0;
            for (int i2 = 0; i2 < this.buttons.length; ++i2) {
                p.add((Component)this.buttons[i2], c);
                c.weightx = 0.0;
            }
            m.add((Component)p, "South");
            this.main = m;
        }
    }

    private void showInfo() {
        this.showComponent(this.main, 0);
    }

    private void showComponent(Component c, int depth) {
        for (int i = 0; i < depth; ++i) {
            System.err.print("  ");
        }
        System.err.print(c.getClass().getName() + " " + c.getName() + ":");
        Dimension pref = c.getPreferredSize();
        Dimension size = c.getSize();
        Dimension diff = new Dimension(size.width - pref.width, size.height - pref.height);
        System.err.print(" pref:[w=" + pref.width + "," + pref.height + "]");
        System.err.print(" size:[w=" + size.width + "," + size.height + "]");
        System.err.print(" diff:[w=" + diff.width + "," + diff.height + "]");
        if (c instanceof Container) {
            Container p = (Container)c;
            System.err.println(" " + p.getComponentCount() + " children");
            for (int i = 0; i < p.getComponentCount(); ++i) {
                this.showComponent(p.getComponent(i), depth + 1);
            }
        } else {
            System.err.println();
        }
    }

    protected Restorer getRestorer() {
        return this.restorer;
    }

    protected void setRestorer(Restorer restorer) {
        this.restorer = restorer;
    }

    public class Restorer {
        private String windowKey;
        private int restorePolicy;
        public static final int RESTORE_NOTHING = 0;
        public static final int RESTORE_ALL = 1;
        private static final String POS_X = ".pos.x";
        private static final String POS_Y = ".pos.y";
        private static final String SIZE_H = ".size.height";
        private static final String SIZE_W = ".size.weight";
        private Preferences prefs;

        public Restorer() {
            this.windowKey = ToolDialog.this.uiKey;
            this.restorePolicy = 0;
            this.prefs = Preferences.access();
        }

        private void save() {
            if (!"".equals(this.windowKey) && this.restorePolicy != 0) {
                Container d = ToolDialog.this.dialog;
                Rectangle r = d.getBounds();
                this.prefs.setPreference(this.windowKey + POS_X, Integer.toString(r.x));
                this.prefs.setPreference(this.windowKey + POS_Y, Integer.toString(r.y));
                this.prefs.setPreference(this.windowKey + SIZE_H, Integer.toString(r.height));
                this.prefs.setPreference(this.windowKey + SIZE_W, Integer.toString(r.width));
            }
        }

        private void restore() {
            if (!"".equals(this.windowKey) && this.restorePolicy != 0) {
                Container c = ToolDialog.this.dialog;
                Rectangle r = c.getBounds();
                int x = Integer.parseInt(this.prefs.getPreference(this.windowKey + POS_X, Integer.toString(r.x)));
                int y = Integer.parseInt(this.prefs.getPreference(this.windowKey + POS_Y, Integer.toString(r.y)));
                int h = Integer.parseInt(this.prefs.getPreference(this.windowKey + SIZE_H, Integer.toString(r.height)));
                int w = Integer.parseInt(this.prefs.getPreference(this.windowKey + SIZE_W, Integer.toString(r.width)));
                Rectangle screenBounds = DeskView.getScreenBounds();
                Rectangle n = new Rectangle(x, y, w, h);
                if (!(n = screenBounds.intersection(n)).isEmpty()) {
                    c.setBounds(n);
                    c.setPreferredSize(n.getSize());
                }
                if (c instanceof Window) {
                    ((Window)c).pack();
                }
            }
        }

        public String getWindowKey() {
            return this.windowKey;
        }

        public void setWindowKey(String windowKey) {
            this.windowKey = windowKey;
        }

        public int getRestorePolicy() {
            return this.restorePolicy;
        }

        public void setRestorePolicy(int restorePolicy) {
            this.restorePolicy = restorePolicy;
        }
    }
}

