/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.api.javax_xml_ws.Service_Mode;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.lib.harness.*;

import java.io.*;
import java.net.*;
import java.util.*;
import java.rmi.*;

import javax.xml.ws.*;

import com.sun.javatest.Status;

public class Client extends ServiceEETest
{

    // Expected Enum Constant Summary
    private final static javax.xml.ws.Service.Mode expectedEnums[] = {
	javax.xml.ws.Service.Mode.MESSAGE,
	javax.xml.ws.Service.Mode.PAYLOAD,
    };

    private boolean findEnums(javax.xml.ws.Service.Mode[] args) {
	boolean pass = true;
	boolean found;
	for(javax.xml.ws.Service.Mode a : args) {
	    found = false;
	    TestUtil.logMsg("Searching expected list of enums for " + a);
	    for(javax.xml.ws.Service.Mode b : expectedEnums) {
		if (a == b) {
		    found = true;
		    break;
		}
	    }
	    if (!found) {
		pass = false;
		TestUtil.logErr("No enum found for " + a);
	    }
	    else {
		TestUtil.logMsg("Enum found for " + a);
	    }
	}
	return pass;
    }

    private void printEnums(javax.xml.ws.Service.Mode[] args) {
	TestUtil.logMsg("Print Enums");
	TestUtil.logMsg("-----------");
	for(javax.xml.ws.Service.Mode c : args)
	    TestUtil.logMsg(""+c);
    }

    public static void main(String[] args) 
    {
	Client theTests = new Client();
	Status s = theTests.run(args, System.out, System.err);
	s.exit();
    }



/*  Test setup */

  /*
   *   @class.setup_props:
   */

    public void setup(String[] args, Properties p) throws Fault
    {
        logMsg("setup ok");
    }

    public void cleanup()  throws Fault {
        logMsg("cleanup ok");
    }

    /*
     *   @testName:  valuesTest
     *
     *   @assertion_ids: JAXWS:JAVADOC:60; JAXWS:JAVADOC:61;
     *
     *   @test_Strategy: Verify javax.xml.ws.Service.Mode.values() returns array
     *                   containing the constants of this enum type. 
     */
    public void valuesTest() throws Fault {
	TestUtil.logTrace("valuesTest");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Call javax.xml.ws.Service.Mode.values() ...");
	    javax.xml.ws.Service.Mode[] methods=javax.xml.ws.Service.Mode.values();
	    printEnums(methods);
	    pass = findEnums(methods);
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("valuesTest failed", e);
        }

	if (!pass)
	    throw new Fault("valuesTest failed");
    }

    /*
     *   @testName:  valueOfTest
     *
     *   @assertion_ids: JAXWS:JAVADOC:59;
     *
     *   @test_Strategy: Verify javax.xml.ws.Service.Mode.valueOf(String name) returns
     *                   the enum constant of this type with specified name. 
     */
    public void valueOfTest() throws Fault {
	TestUtil.logTrace("valuesTest");
	boolean pass = true;
        try {
	    TestUtil.logMsg("Call javax.xml.ws.Service.Mode.valueOf(MESSAGE) ...");
	    javax.xml.ws.Service.Mode method = javax.xml.ws.Service.Mode.valueOf("MESSAGE");
	    if (method != javax.xml.ws.Service.Mode.MESSAGE) {
		TestUtil.logErr("javax.xml.ws.Service.Mode.valueOf(MESSAGE) failed:"+
			" expected: " + javax.xml.ws.Service.Mode.MESSAGE +
			", received: " + method);
		pass = false;
	    }
	    else {
		TestUtil.logMsg("javax.xml.ws.Service.Mode.valueOf(MESSAGE) passed");
	    }
        } catch (Exception e) {
	    TestUtil.logErr("Caught exception: " + e.getMessage());
            TestUtil.printStackTrace(e);
	    throw new Fault("valuesTest failed", e);
        }

	if (!pass)
	    throw new Fault("valuesTest failed");
    }
}
