/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.jaxws.common;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;

import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.MessageContext;
import javax.xml.namespace.QName;
import java.util.Set;

public abstract class HTTPSOAPHandler implements SOAPHandler<SOAPMessageContext>
{
    public boolean handleMessage(SOAPMessageContext context)
    {
        System.out.println("entering HTTPSOAPHandler:handleMessage");
        boolean outbound = (Boolean)context.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

        if (outbound) {
            System.out.println("Direction=outbound");
            processOutboundMessage(context);
        } else {
            System.out.println("Direction=inbound");
            processInboundMessage(context);
        }
 
        System.out.println("exiting HTTPSOAPHandler:handleMessage");
        return true;
    }


    public void close(MessageContext context)
    {
    }

    public boolean handleFault(SOAPMessageContext context)
    {
        return true;
    }
    public Set<QName> getHeaders() {
       return null;
    }
    protected void processOutboundMessage(SOAPMessageContext context) {
    }
    protected void processInboundMessage(SOAPMessageContext context) {
    }
}
