/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleTestClient.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.sharedclients.simpleclient;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;


public class SimpleTestClient extends SOAPClient {

    public SimpleTestClient(String webServerHost, int webServerPort, int mode) throws EETest.Fault{
        this(webServerHost, webServerPort, mode, null);
    }

    public SimpleTestClient(String webServerHost, int webServerPort, int mode, javax.xml.ws.Service webServiceRef) throws EETest.Fault{
        super(webServerHost, webServerPort, mode);
        stubContext.setNamespace("http://simpletestservice.org/wsdl");
        stubContext.setService("SimpleTest");
        stubContext.setPort("SimpleEndpointPort");
        stubContext.setEndpointInterface(SimpleEndpoint.class);
	stubContext.setWebServiceRef(webServiceRef);
    }

    protected String getEndpointURLProperty() {
        return "wsi.simple.endpoint.1";
    }

    protected String getWSDLURLProperty() {
        return "wsi.simple.wsdlloc.1";
    }

    public String helloWorld() throws Exception{
        TestUtil.logMsg("STUB CLASS: " + stubContext.getStub().getClass().getName());
        return ((SimpleEndpoint)stubContext.getStub()).helloWorld();
    }

    public String arrayOperationFromClient(String [] array) throws Exception{
	StringArray strArr = new StringArray();
	for(int i=0; i<array.length; i++)
	    strArr.getItem().add(array[i]);
        return ((SimpleEndpoint)stubContext.getStub()).arrayOperationFromClient(strArr);
    }
}
