/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: ServerLogicalHandler5.java 62638 2011-04-26 16:08:02Z adf $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.dlhandlerservice;

import com.sun.ts.lib.util.*;
import com.sun.ts.lib.porting.*;
import com.sun.ts.tests.jaxws.common.*;

import com.sun.ts.tests.jaxws.common.LogicalHandlerBase;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.soap.SOAPFaultException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.Name;


public class ServerLogicalHandler5 extends LogicalHandlerBase
{
    private static final String WHICHHANDLERTYPE="Server";
    private static final String HANDLERNAME="ServerLogicalHandler5";
    private static final String NAMESPACEURI = "http://dlhandlerservice.org/wsdl";
    private final QName FAULTCODE = new QName(NAMESPACEURI, "ItsASoapFault", "tns");
    private static final String FAULTACTOR = "faultActor";
    private Name name = null;
    private javax.xml.soap.SOAPFault sf;


    public ServerLogicalHandler5(){
       super();
       super.setWhichHandlerType(WHICHHANDLERTYPE);
       super.setHandlerName(HANDLERNAME);
    }

    public boolean handleMessage(LogicalMessageContext context)
    {
      System.out.println("in "+this+":handleMessage");
      TestUtil.logTrace("in "+this+":handleMessage");
          Handler_Util.setTraceFlag(Handler_Util.getValueFromMsg(this, context, "harnesslogtraceflag"));

          Handler_Util.initTestUtil(this,
                                    Handler_Util.getValueFromMsg(this, context, "harnessloghost"),
                                    Handler_Util.getValueFromMsg(this, context, "harnesslogport"),
                                    Handler_Util.getValueFromMsg(this, context, "harnesslogtraceflag"));

         String direction = Handler_Util.getDirection(context);
         if (!Handler_Util.checkForMsg(this, context, "GetTrackerData")) {
             HandlerTracker.reportHandleMessage(this, direction);
             if (direction.equals(Constants.INBOUND)){
                 if (Handler_Util.checkForMsg(this, context,"ServerLogicalInboundHandleFaultFalseTest")) {
                    HandlerTracker.reportComment(this, "Throwing an inbound SOAPFaultException");
                    String faultString = "ServerLogicalHandler5.handleMessage throws SOAPFaultException for ServerLogicalInboundHandleFaultFalseTest";
                    try {
                        name = SOAPFactory.newInstance().createName("somefaultentry");
                        sf = JAXWS_Util.createSOAPFault("soap11", FAULTCODE, FAULTACTOR, faultString, name);
                    } catch (Exception e) {
                        HandlerTracker.reportThrowable(this, new Exception("Unexpected error occurred in handleMessage for an outbound message"+e));
                     
                    }
                    throw new SOAPFaultException(sf);
                 } else if (Handler_Util.checkForMsg(this, context,"ServerLogicalInboundHandleFaultThrowsRuntimeExceptionTest")) {
                    HandlerTracker.reportComment(this, "Throwing an inbound SOAPFaultException");
                    String faultString = "ServerLogicalHandler6.handleMessage throws SOAPFaultException for ServerLogicalInboundHandleFaultThrowsRuntimeExceptionTest";
                    try {
                        name = SOAPFactory.newInstance().createName("somefaultentry");
                        sf = JAXWS_Util.createSOAPFault("soap11", FAULTCODE, FAULTACTOR, faultString, name);
                    } catch (Exception e) {
                        HandlerTracker.reportThrowable(this, new Exception("Unexpected error occurred in handleMessage for an inbound message"+e));
                    }
                    throw new SOAPFaultException(sf);
                 } else if (Handler_Util.checkForMsg(this, context,"ServerLogicalInboundHandleFaultThrowsSOAPFaultExceptionTest")) {
                    HandlerTracker.reportComment(this, "Throwing an inbound SOAPFaultException");
                    String faultString = "ServerLogicalHandler6.handleMessage throws SOAPFaultException for ServerLogicalInboundHandleFaultThrowsSOAPFaultExceptionTest";
                    try {
                        name = SOAPFactory.newInstance().createName("somefaultentry");
                        sf = JAXWS_Util.createSOAPFault("soap11", FAULTCODE, FAULTACTOR, faultString, name);
                    } catch (Exception e) {
                        HandlerTracker.reportThrowable(this, new Exception("Unexpected error occurred in ServerSOAPHandler6.handleMessage for an inbound message"+e));
                    }
                    throw new SOAPFaultException(sf);
                 }

             }
         }

     System.out.println("exiting "+this+":handleMessage");
     TestUtil.logTrace("exiting "+this+":handleMessage");
     return true;
  }

}
