/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Hello2Impl.java 51047 2006-01-17 19:39:40Z adf $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.doclithelloservice;

import javax.xml.ws.WebServiceException;

import javax.jws.WebService;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.MTOM;

@WebService(
    portName="Hello2Port",
    serviceName="HelloService",
    targetNamespace="http://helloservice.org/wsdl",
    wsdlLocation="WEB-INF/wsdl/WSDLHelloService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.sharedwebservices.doclithelloservice.Hello2"
)
@Addressing
@MTOM
public class Hello2Impl implements Hello2 {
    private static final ObjectFactory of = new ObjectFactory();

    public HelloResponse hello(HelloRequest req) {
        System.out.println("Hello2Impl received: " + req.getArgument());
        HelloResponse resp = null;
        resp = of.createHelloResponse();
        resp.setArgument(req.getArgument());
        return resp;
    }

    public void helloOneWay(HelloOneWayRequest req) {
        System.out.println("Hello2Impl received: " + req.getArgument());
    }
}
