/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HelloImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

package com.sun.ts.tests.jaxws.sharedwebservices.xmlbinddlhelloproviderservice;

import javax.xml.ws.*;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import java.io.StringReader;
import java.io.OutputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.ws.http.HTTPBinding;

import com.sun.ts.tests.jaxws.common.JAXWS_Util;

@WebServiceProvider
@BindingType(value=HTTPBinding.HTTP_BINDING)
@ServiceMode (value=javax.xml.ws.Service.Mode.MESSAGE)
public class HelloImpl implements Provider<Source> {
    private static final javax.xml.bind.JAXBContext jaxbContext = createJAXBContext();
    private static int combo = -1;

    public javax.xml.bind.JAXBContext getJAXBContext(){
        return jaxbContext;
    }
    
    private static javax.xml.bind.JAXBContext createJAXBContext(){
        try{
            return javax.xml.bind.JAXBContext.newInstance(com.sun.ts.tests.jaxws.sharedwebservices.xmlbinddlhelloproviderservice.ObjectFactory.class);
        }catch(javax.xml.bind.JAXBException e){
            throw new WebServiceException(e.getMessage(), e);
        }
    }

    public Source invoke(Source source)  {
	System.out.println("**** Received in Provider Impl ******");
	try {
	  recvBean(source);
	}
	catch (Exception e) {
	    e.printStackTrace();
	    throw new WebServiceException("Provider endpoint failed", e);
	}
	return sendSource();
    }

    private Source sendSource() {
	System.out.println("*** sendSource ***");
	String body = "<HelloResponse xmlns=\"http://helloservice.org/types\"><argument>foo</argument></HelloResponse>";
 	Source source = new StreamSource(new StringReader(body));
	return source;
    }

    private void recvBean(Source req) throws Exception {
	System.out.println("*** recvBean ***");
	HelloRequest helloReq = null;
	try {
	    helloReq = (HelloRequest) jaxbContext.createUnmarshaller().unmarshal(req);
	    System.out.println("argument="+helloReq.getArgument());
	} catch (Exception e){
            System.out.println("Received an exception while parsing the source");
            e.printStackTrace();
	    throw e;
	}
    }
}
