/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: Client.java 62602 2011-04-21 14:51:41Z kgrucci $
 */

/* Copyright (c) 2003 Oracle Corporation.  All rights reserved.  */
package com.sun.ts.tests.jaxws.wsi.j2w.rpc.literal.R2206;

import java.util.Properties;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.sun.javatest.Status;
import com.sun.ts.tests.jaxws.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxws.sharedclients.SOAPClient;
import com.sun.ts.tests.jaxws.sharedclients.rpclitclient.*;
import com.sun.ts.tests.jaxws.wsi.constants.DescriptionConstants;
import com.sun.ts.tests.jaxws.wsi.constants.SchemaConstants;
import com.sun.ts.tests.jaxws.wsi.utils.DescriptionUtils;

import com.sun.ts.lib.harness.*;

public class Client extends ServiceEETest implements DescriptionConstants, SchemaConstants {
    /**
     * The client.
     */
    private SOAPClient client;
    
    
    static J2WRLShared service = null;

    /**
     * The document.
     */
    private Document document;
    
    /**
     * Test entry point.
     * 
     * @param args the command-line arguments.
     */
    public static void main(String[] args) {
        Client test = new Client();
        Status status = test.run(args, System.out, System.err);
        status.exit();
    }

    
    /**
     * @class.testArgs:     -ap jaxws-url-props.dat
     * @class.setup_props: webServerHost;
     *                     webServerPort;
     *                     platform.mode;
     *
     * @param args
     * @param properties
     *
     * @throws Fault
     */
    public void setup(String[] args, Properties properties) throws Fault {
        client = ClientFactory.getClient(J2WRLSharedClient.class, properties, this, service);
        logMsg("setup ok");
    }

    public void cleanup() {
        logMsg("cleanup");
    }

    /**
     * @testName: testElementParts
     *
     * @assertion_ids: WSI:SPEC:R2206
     *
     * @test_Strategy: Retrieve the WSDL, generated by the Java-to-WSDL tool,
     * and examine all message elements and verify all part elements, defined by the
     * element attribute, ensuring that they reference a global element.
     * 
     * @throws Fault
     */
    public void testElementParts() throws Fault {
        document = client.getDocument();
        Element[] messages = DescriptionUtils.getMessages(document);
        for (int i = 0; i < messages.length; i++) {
            verifyMessage(messages[i]);
        }
    }
    
    protected void verifyMessage(Element message) throws Fault {
        Element[] parts = DescriptionUtils.getChildElements(message, WSDL_NAMESPACE_URI, WSDL_PART_LOCAL_NAME);
        for (int i = 0; i < parts.length; i++) {
            verifyPart(parts[i]);
        }
    }
    
    protected void verifyPart(Element part) throws Fault {
        Attr attr = part.getAttributeNode(WSDL_ELEMENT_ATTR);
        if (attr == null) {
            return;
        }
        String value = attr.getValue();
        int index = value.indexOf(':');
        String prefix = value.substring(0, index);
        String name = value.substring(index + 1);
        System.out.println("name ="+name);
        System.out.println("prefix ="+prefix);
        String namespaceURI = DescriptionUtils.getNamespaceURI(part, prefix);
        System.out.println("namespaceURI ="+namespaceURI);
        if (namespaceURI == null) {
            throw new Fault("xmlns:" + prefix + " not defined (BP-R2206)");
        }
        System.out.println("----------------------------");
    }
    
}
