/*
 * Copyright (c) 2007, 2009, Oracle and its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
/*
 * $Id: W2JRLR2738TestImpl.java 62602 2011-04-21 14:51:41Z kgrucci $
 */
package com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2738;

import javax.xml.ws.Holder;

import javax.xml.ws.WebServiceException;
import javax.jws.WebService;

@WebService(
    portName="W2JRLR2738TestPort",
    serviceName="W2JRLR2738TestService",
    targetNamespace="http://w2jrlr2738testservice.org/W2JRLR2738TestService.wsdl",
    wsdlLocation="WEB-INF/wsdl/W2JRLR2738TestService.wsdl",
    endpointInterface="com.sun.ts.tests.jaxws.wsi.w2j.rpc.literal.R2738.W2JRLR2738Test"
)

public class W2JRLR2738TestImpl implements W2JRLR2738Test {
    public void echoIt(String text, 
                       ConfigHeader ch1, 
                       Holder<ConfigHeader> ghch2,
                       Holder<String> ghresult,
                       Holder<ConfigHeader> ghch3)  {


          String result="";
          String expected="IncludeAllSoapHeadersTest";
          if (text.equals(expected))  {
             if ((ch1.getMessage().equals("ConfigHeader1")) &&
                (ghch2.value.getMessage().equals("ConfigHeader2"))){
                if ((ghch3.value==null) || (!ghch3.value.getMessage().equals("ConfigHeader3")))  {
                   result="PASSED";
                } else {
                   throw new WebServiceException("FAILED in endpoint - expected configHeader3 not to be ConfigHeader3");
                }
             } else {
                throw new WebServiceException("FAILED in endpoint - ch1="+ch1.getMessage()+", ghch2="+ghch2.value.getMessage());
             }
          } else {
             throw new WebServiceException("FAILED in endpoint - the body text was not correct: expected="+expected+", got="+text);
          }
          ch1.setMessage("ConfigHeader11");
          ConfigHeader ch2 = new ConfigHeader();
          ch2.setMessage("ConfigHeader22");
          ghch2.value=ch2;
          ConfigHeader ch3 = new ConfigHeader();
          ch3.setMessage("ConfigHeader33");
          ghch3.value=ch3;
	     ghresult.value = result;
    }
}
