/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = "A_BASIC")
public class FieldStringId implements java.io.Serializable {

    // ===========================================================
    // instance variables 

    @Id
    protected String id;
    
    @Basic
    protected String name;
    
    // ===========================================================
    // constructors
    public FieldStringId() {
    }

    public FieldStringId(String id, String name) {
        
        this.id = id;
        this.name = name;

    }


    public String getId() {
        return id;
    }
    
    public void setId(String id){
        this.id=id;       
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         if (getName() != null){
             result.append(", name: " + getName());
         } else {
             result.append(", name: null");
         }
         result.append("]");
         return result.toString();
     }
}
