/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.annotations.id;


import com.sun.ts.lib.util.TestUtil;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Entity
@Table(name = "DATATYPES3")
public class PropertyBigDecimalId implements java.io.Serializable {

    // ===========================================================
    // instance variables


    protected BigDecimal id;

    private BigDecimal bigDecimal;


    // ===========================================================
    // constructors
    public PropertyBigDecimalId() {
    }

    public PropertyBigDecimalId(BigDecimal id, BigDecimal bigDecimal) {

        this.id = id;
        this.bigDecimal = bigDecimal;

    }

    @Id
    @Column(name = "ID")
    public BigDecimal getId() {
        return id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    @Column(name = "THEVALUE")
    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    public void setBigDecimal(BigDecimal bigDecimal) {
        this.bigDecimal = bigDecimal;
    }
    @Override
     public String toString() {
         StringBuilder result = new StringBuilder();
         result.append(this.getClass().getSimpleName() + "[");
         result.append("id: " + getId());
         if (getBigDecimal() != null){
             result.append(", BigDecimal: " + getBigDecimal());
         } else {
             result.append(", BigDecimal: null");
         }
         result.append("]");
         return result.toString();
     }
}
