/*
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 
package com.sun.ts.tests.jpa.core.annotations.mapkeytemporal;

import javax.persistence.*;

/*
 * Employee
 */

@Entity
@Table(name="EMP_MAPKEYCOL2")
public class Employee implements java.io.Serializable {

    private int	     	     id;
    private String	     lastName;
    private Department       department;

    public Employee() {
    }

    public Employee(int id, String lastName)
    {
        	this.id = id;
        	this.lastName = lastName;
    }

   // ===========================================================
   // getters and setters for the state fields

    @Id
    @Column(name="ID")
    public int getId() {
        return id;
    }
    public void setId(int id) {
        this.id = id;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return lastName;
    }
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

   // ===========================================================
   // getters and setters for the association fields

    @ManyToOne
    @JoinColumn(name="FK_DEPT5")
    public Department getDepartment() {
        return department;
    }
    public void setDepartment(Department department) {
        this.department = department;
    }

    @Override
    public int hashCode() {
        return this.getId() +
                this.getLastName().hashCode();
    }

    public boolean equals(Object o) {
        Employee other;
        boolean same = true;

        if (!(o instanceof Employee)) {
            return false;
        }
        other = (Employee) o;

        same &= (this.id==other.id);

        return same;
    }
    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        if (getLastName() != null) {
            result.append(", name: " + getLastName());
        } else {
            result.append(", name: null");
        }
        result.append("]");
        return result.toString();
    }
}

