/*
 * Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: LineItem.java 65615 2012-03-29 19:02:39Z sdimilla $
 */

package com.sun.ts.tests.jpa.core.callback.methodoverride;

import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusIF;
import com.sun.ts.tests.jpa.core.callback.common.CallbackStatusImpl;
import com.sun.ts.tests.jpa.core.callback.common.GenerictListenerImpl;

import javax.persistence.*;

@Entity
@Table(name="LINEITEM_TABLE")
public class LineItem extends CallbackStatusImpl
        implements java.io.Serializable, CallbackStatusIF {
    private String id;
    private int quantity;
    private Order order;
    private Product product;
    private GenerictListenerImpl callbackImpl = new GenerictListenerImpl();
    
    public LineItem() {
        super();
    }
    
    public LineItem(String v1, int v2, Order v3, Product v4) {
        id = v1;
        quantity = v2;
        order = v3;
        product = v4;
    }
    
    public LineItem(String v1, int v2) {
        id = v1;
        quantity = v2;
    }
    
    @Transient
    public GenerictListenerImpl getCallbackImpl() {
	return callbackImpl;
    }
    public void setCallbackImpl(GenerictListenerImpl callbackImpl) {
	this.callbackImpl = callbackImpl;
    }
    /////////////////////////////////////////////////////////////////////////
    //@PrePersist
    private void prePersist() {
        getCallbackImpl().prePersist(this);
    }

    //@PostPersist
    private void postPersist() {
        getCallbackImpl().postPersist(this);
    }
    
    
    //@PreRemove
    private void preRemove() {
       getCallbackImpl().preRemove(this);
    }
    //@PostRemove
    private void postRemove() {
        getCallbackImpl().postRemove(this);
    }
    
    
    //@PreUpdate
    private void preUpdate() {
        getCallbackImpl().preUpdate(this);
    }
    //@PostUpdate
    private void postUpdate() {
        getCallbackImpl().postUpdate(this);
    }
    
    //@PostLoad
    private void postLoad() {
        getCallbackImpl().postLoad(this);
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    @Id
    @Column(name="ID")
    public String getId() {
        return id;
    }
    public void setId(String v) {
        id = v;
    }
    
    @Column(name="QUANTITY")
    public int getQuantity() {
        return quantity;
    }
    
    public void setQuantity(int v) {
        quantity = v;
    }
    
    @ManyToOne
    @JoinColumn(name="FK1_FOR_ORDER_TABLE")
    public Order getOrder() {
        return order;
    }
    public void setOrder(Order v) {
        order = v;
    }
    
    @ManyToOne
    @JoinColumn(name="FK_FOR_PRODUCT_TABLE")
    public Product getProduct() {
        return product;
    }
    public void setProduct(Product v) {
        product = v;
    }
}
