/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex4a;


import com.sun.javatest.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;

import java.util.List;
import java.util.Properties;

/**
 * @author Raja Perumal
 */
public class Client extends PMClientBase {

    public Client() {
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        TestUtil.logTrace("setup");
        try {
            super.setup(args, p);
            removeTestData();
        } catch (Exception e) {
            TestUtil.logErr("Exception: " , e);
            throw new Fault("Setup failed:", e);
        }
    }

    /*
     * @testName: DIDTest
     *
     * @assertion_ids: PERSISTENCE:SPEC:1339; PERSISTENCE:SPEC:1179
     *
     * @test_Strategy: Derived Identifier
     * 
     *     The parent entity has a simple primary key
     *     Case (a): The dependent entity has a single relationship attribute
     *     corresponding to the parents primary key. The primary key of
     *     MedicalHistory is of type String.
     */
    public void DIDTest() throws Fault {
        boolean pass = false;


        try {


            getEntityTransaction().begin();
            final DID4Person person = new DID4Person("123456789", "DUKE");
            final DID4MedicalHistory mHistory = new DID4MedicalHistory(person, "drFoo");

            getEntityManager().persist(person);
            getEntityManager().persist(mHistory);

            TestUtil.logTrace("persisted Patient and MedicalHistory");
            getEntityManager().flush();

            // Refresh MedicalHistory
            DID4MedicalHistory newMHistory = getEntityManager().find(DID4MedicalHistory.class, "123456789");
            if (newMHistory != null) {
                getEntityManager().refresh(newMHistory);
            }

            final List depList = getEntityManager().createQuery("Select m from DID4MedicalHistory m where m.patient.ssn='123456789'").getResultList();
            newMHistory = null;
            if (depList.size() > 0) {
                newMHistory = (DID4MedicalHistory) depList.get(0);
                if (newMHistory != null) {
                    if (newMHistory.getPatient() == person) {
                        pass = true;
                        TestUtil.logTrace("Received Expected Patient");
                    } else {
                        TestUtil.logErr("Searched Patient not found");
                    }
                } else {
                    TestUtil.logErr("getEntityManager().createQuery returned null entry");
                }
            } else {
                TestUtil.logErr("getEntityManager().createQuery returned null");
            }
            getEntityTransaction().commit();
        } catch (Exception e) {
            TestUtil.logErr("Unexpected exception occurred", e);
            getEntityTransaction().rollback();
        }

        if (!pass) {
            throw new Fault("DTDTest failed");
        }
    }

    public void cleanup() throws Fault {
        TestUtil.logTrace("cleanup");
        removeTestData();
        TestUtil.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace("removeTestData");
        if (getEntityTransaction().isActive()) {
            getEntityTransaction().rollback();
        }
        try {
            getEntityTransaction().begin();
            getEntityManager().createNativeQuery("DELETE FROM DID4MEDICALHISTORY").executeUpdate();
            getEntityManager().createNativeQuery("DELETE FROM DID4PERSON").executeUpdate();
            getEntityTransaction().commit();
        } catch (Exception e) {
            TestUtil.logErr("Exception encountered while removing entities:",e);
        } finally {
            try {
                if (getEntityTransaction().isActive()) {
                    getEntityTransaction().rollback();
                }
            } catch (Exception re) {
                TestUtil.logErr("Unexpected Exception in removeTestData:",re);
            }
        }
    }
}
