/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.collectionattribute;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Collection;

/**
 *
 * @author Raja Perumal
 */
@Entity
public class Uni1XMPerson implements Serializable {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    private String name;

    // One Person ManyProjects
    @OneToMany(cascade = CascadeType.ALL)
    private Collection<Uni1XMProject> projects;

    public Uni1XMPerson() {
    }

    public Uni1XMPerson(long l, String string) {
        this.id = l;
        this.name = string;
    }

    public Collection<Uni1XMProject> getProjects() {
        return projects;
    }

    public void setProjects(Collection<Uni1XMProject> projects) {
        this.projects = projects;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Uni1XMPerson)) {
            return false;
        }
        Uni1XMPerson other = (Uni1XMPerson) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "unionexmany.Uni1XMPerson[id=" + id + "]";
    }
}
