/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.entitytype;

import com.sun.ts.lib.util.TestUtil;

import javax.persistence.*;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name = "COLTAB")
@AttributeOverrides({
        @AttributeOverride(name="name",column=@Column(name="NAME"))
})
public class A extends B {

    @Id
    protected String id;
    @Version
    protected Integer value;

    @ElementCollection
    @CollectionTable(name = "COLTAB_ADDRESS", joinColumns=@JoinColumn(name="A_ID"))
    protected Set<Address> address = new HashSet();

    public A() {
    }

    public A(String id, String name, int value) {
        super(name);
        this.id = id;
        this.value = value;
    }

    public Set<Address> getAddress() {
        TestUtil.logTrace("getAddress");
        return address;
    }

    public void setAddress(Set<Address> addr) {
        TestUtil.logTrace("setAddress");
        this.address = addr;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getValue() {
        return value;
    }

    public void setValue(Integer val) {
        this.value = val;
    }
}
