/*
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
 


package com.sun.ts.tests.jpa.core.metamodelapi.metamodel;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Date;

/*
 * FullTimeEmployee entity extends an MappedSuperClass while overriding
 * mapping information.
 */

@Entity
@Table(name="EMPLOYEE")
@AttributeOverrides({
        @AttributeOverride(name="id",column=@Column(name="ID")),
        @AttributeOverride(name="firstName",column=@Column(name="FIRSTNAME")),
        @AttributeOverride(name="lastName",column=@Column(name="LASTNAME")),
        @AttributeOverride(name="hireDate",column=@Column(name="HIREDATE"))
})
@Access(AccessType.PROPERTY)
public class FullTimeEmployee extends Employee implements Serializable{

    private float salary;

    public FullTimeEmployee() {
    }

    public FullTimeEmployee(int id, String firstName, String lastName, Date hireDate,
                            float salary)
    {
                super(id, firstName, lastName, hireDate);
                this.salary = salary;
    }

   // ===========================================================
   // getters and setters for the state fields

    @Column(name="SALARY")
    public float getSalary() {
        return salary;
    }
    public void setSalary(float salary) {
        this.salary = salary;
    }
    
}
