/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.sun.ts.tests.jpa.se.schemaGeneration.annotations.version;

import javax.persistence.*;

@Entity
@Table(name = "SCHEMAGENSIMPLE")
public class Simple implements java.io.Serializable {

    int id;
    int version;


    public Simple() {
    }

    public Simple(int id) {
        this.id = id;
    }


    @Id
    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Version
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

     @Override
    public boolean equals(Object o) {
        //check for self-comparison
        if (this == o) return true;
        if (!(o instanceof Simple)) return false;

        Simple o1 = (Simple) o;

        boolean result = false;

        if (this.getId() == o1.getId() ) {
            result = true;
        }

        return result;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName() + "[");
        result.append("id: " + getId());
        result.append(", version " + getVersion());
        result.append("]");
        return result.toString();
    }

}
