/*
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 72229 2013-06-25 18:20:40Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.el.variableresolver;

import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.AbstractUrlClient;

import java.io.PrintWriter;

public final class URLClient extends AbstractUrlClient {

	private static final String CONTEXT_ROOT = "/jsf_el_varresolver_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out),
				new PrintWriter(System.err));
		s.exit();
	}

	public Status run(String args[], PrintWriter out, PrintWriter err) {
		setContextRoot(CONTEXT_ROOT);
		setServletName(DEFAULT_SERVLET_NAME);
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/* Test Declarations */

	/**
	 * @testName: varResolverResolveVariableTest
	 * @assertion_ids: JSF:JAVADOC:1770
	 * @test_Strategy: Ensure a non-null result for a variable that is known to
	 *                 resolve on all implementations and null is returned for a
	 *                 variable that can't be resolved.
	 */
	public void varResolverResolveVariableTest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "varResolverResolveVariableTest");
		invoke();
	}

	/**
	 * @testName: varResolverResolveVariableNPETest
	 * @assertion_ids: JSF:JAVADOC:1772
	 * @test_Strategy: Ensure an NPE is thrown if the FacesContext or name
	 *                 paramters are null.
	 */
	public void varResolverResolveVariableNPETest() throws Fault {
		TEST_PROPS.setProperty(APITEST, "varResolverResolveVariableNPETest");
		invoke();
	}

} // end of URLClient
