/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: TestServlet.java 64808 2012-02-07 18:11:12Z dougd $
 */

package com.sun.ts.tests.jsf.api.javax_faces.event.preremoveflashvalueevent;

import java.io.IOException;
import java.io.PrintWriter;

import javax.faces.application.Application;
import javax.faces.event.PreRemoveFlashValueEvent;
import javax.faces.event.SystemEvent;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sun.ts.tests.jsf.api.javax_faces.event.common.BaseSystemEventTestServlet;
import com.sun.ts.tests.jsf.common.util.JSFTestUtil;

public class TestServlet extends BaseSystemEventTestServlet {
    private static final String FLASH_KEY = "key"; 
    
    @Override
    protected SystemEvent createEvent(Object src) {
	return new PreRemoveFlashValueEvent(FLASH_KEY);
    }
    
    // ------------------------------------------- PostKeepFlashValueEvent
    
    public void preRemoveFlashValueEventGetKeyTest(HttpServletRequest request,
	    HttpServletResponse response) throws ServletException, IOException {
	PrintWriter pw = response.getWriter();
	Application app = getFacesContext().getApplication();

	if (app != null) {
	    PreRemoveFlashValueEvent pKeep = (PreRemoveFlashValueEvent) createEvent(app);
	    String result = pKeep.getKey();
	    
	    if (!FLASH_KEY.equals(result)) {
		pw.println(JSFTestUtil.FAIL + " Wrong key value!" + JSFTestUtil.NL +
			"Expected: " + FLASH_KEY + JSFTestUtil.NL +
			"Received: " + result);
	    } else {
		pw.println(JSFTestUtil.PASS);
	    }
	    
	} else {
	    pw.println(JSFTestUtil.FAIL +" Unexpected problem obtaining "
		    + "Application instance.");
	}
    } // End preRemoveFlashValueEventGetKeyTest
    
} // End TestServlet