/*
 * Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: FactoryTCKServlet.java 62525 2011-04-15 12:14:31Z dougd $
 */

package com.sun.ts.tests.jsf.common.servlets;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


public class FactoryTCKServlet extends HttpServlet{

       /**
     * A basic implementation of the <code>doGet</code> method which will
     * call invokeTest.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     * @exception IOException if an IO error occurs
     */
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {
        invokeTest(req, res);
    }

    /**
     * A basic implementation of the <code>doPost</code> method which will
     * call invokeTest.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     * @exception IOException if an IO error occurs
     */
    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res)
            throws ServletException, IOException {

        invokeTest(req, res);

    }
    //---------------------------------------------------------- private methods
    /**
     * <code>invokeTest</code> uses reflection to invoke test methods
     * in child classes of this particular class.
     *
     * @param req - <code>HttpServletRequest</code>
     * @param res - <code>HttpServletResponse</code>
     * @exception ServletException if an error occurs
     */
    @SuppressWarnings("static-access")
    protected void invokeTest(HttpServletRequest req, HttpServletResponse res)
            throws ServletException {
        res.setContentType("text/plain");
        char[] temp = req.getParameter("testname").toCharArray();
        temp[0] = Character.toLowerCase(temp[0]);
        String test = new String(temp);


        Method[] methods = this.getClass().getMethods();
        //(test, TEST_ARGS);
        Method method = null;
        for (int i = 0; i < methods.length; i++) {
            method = methods[i];
            if (method.getName().equals(test)) {
                break;
            }
        }
        if (method == null) {
            throw new ServletException("Test: " + test + " does not exist.");
        }
        try {
            method.invoke(this, new Object[]{
                        req,
                        res
                    });
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (Exception e) {
            throw new ServletException("Error executing test: " + test, e);

        }
    }
}
