/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: URLClient.java 70030 2013-02-14 14:54:29Z dougd $
 */
package com.sun.ts.tests.jsf.spec.flows.factory;

import java.io.PrintWriter;

import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.sun.javatest.Status;
import com.sun.ts.tests.jsf.common.client.BaseHtmlUnitClient;

public class URLClient extends BaseHtmlUnitClient {

	private static final String CONTEXT_ROOT = "/jsf_flows_factory_web";

	public static void main(String[] args) {
		URLClient theTests = new URLClient();
		Status s = theTests.run(args, new PrintWriter(System.out, true),
				new PrintWriter(System.err, true));
		s.exit();
	}

	public Status run(String[] args, PrintWriter out, PrintWriter err) {
		return super.run(args, out, err);
	}

	/*
	 * @class.setup_props: webServerHost; webServerPort; ts_home;
	 */

	/**
	 * @testName: facesFlowFactoryTest
	 * 
	 * @assertion_ids: PENDING
	 * 
	 * @test_Strategy: Validate that using a custom FlowsFactory works.
	 * 
	 * @since 2.2
	 */
	public void facesFlowFactoryTest() throws Fault {
		StringBuilder messages = new StringBuilder(128);

		HtmlPage page = getPage(CONTEXT_ROOT + "/faces/index.xhtml");
		doesPageContain(page, "Page with link to flow entry", messages);
		
		page = doClick((HtmlSubmitInput) page.getElementById("start"));

		doesPageContain(page, "First page in the flow", messages);
		doesPageContain(page, "basicFlow", messages);
		doesPageContain(page, "Did we wrap: true", messages);
		doesPageContain(page, "Did we inject: MyAppBean", messages);
		
	} // END facesFlowFactoryTest

} // END URLClient
