/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: BodyContentWriteOutTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodycontent;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class BodyContentWriteOutTag extends BodyTagSupport {

    /**
     * Default constructor.
     */
    public BodyContentWriteOutTag() {
	super();
    }

    /**
     * Validates the behavior of BodyContent.writeOut().
     * 
     * @return SKIP_BODY
     * @throws JspException
     *             if an error occurs
     */
    public int doAfterBody() throws JspException {
	JspTestUtil.debug("[BodyContentWriteOutTag] in doAfterBody()");
	BodyContent content = this.getBodyContent();

	try {
	    // write the content of the body to the current writer
	    content.writeOut(content.getEnclosingWriter());

	} catch (IOException ioe) {
	    throw new JspException("Test FAILED. Unexpected IOException!", ioe);
	} catch (Exception e) {
	    throw new JspException("Test FAILED. Unexpected Exception!", e);
	}
	return SKIP_BODY;
    }
}
