/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: GetPreviousOutTestTag.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodytagsupport;

import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import java.io.IOException;

public class GetPreviousOutTestTag extends BodyTagSupport {

    /**
     * Default constructor.
     */
    public GetPreviousOutTestTag() {
        super();
    }

    /**
     * Validates getPreviousOut().
     * @return Tag.EVAL_PAGE
     * @throws JspException - if an error occurs
     */
    public int doEndTag() throws JspException {
        try {
            JspWriter out = this.getPreviousOut();

            // clear the buffer from the page
           out.clear();
            out.println("Test PASSED");
        } catch (IOException ioe) {
            throw new JspException("Unexpected Exception!", ioe);
        }
        return EVAL_PAGE;
    }
}
