/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SyncTEI.java 62554 2011-04-15 18:08:28Z dougd $
 */

package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.bodytagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import javax.servlet.jsp.tagext.TagData;

public class SyncTEI extends TagExtraInfo {

    /**
     * Default constructor.
     */
    public SyncTEI() {
        super();
    }

    /**
     * Sets the begin, nested, and end scripting variables for
     * the BodySynchronizationTag.
     * @param data - the TagData from the TLD.
     * @return a VariableInfo array.
     */
    public VariableInfo[] getVariableInfo(TagData data) {
        JspTestUtil.debug("[SyncTEI] in getVariableInfo()");
        return new VariableInfo[] {
            new VariableInfo("begin", "java.lang.Integer", true, VariableInfo.AT_BEGIN),
            new VariableInfo("nested", "java.lang.Integer", true, VariableInfo.NESTED),
            new VariableInfo("end", "java.lang.Integer", true, VariableInfo.AT_END)
        };
    }
}
