/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SimpleNoParent.java 62554 2011-04-15 18:08:28Z dougd $
 */
 
package com.sun.ts.tests.jsp.api.javax_servlet.jsp.tagext.simpletagsupport;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;

import javax.servlet.jsp.tagext.SimpleTagSupport;
import javax.servlet.jsp.tagext.JspTag;
import javax.servlet.jsp.tagext.SimpleTag;
import javax.servlet.jsp.JspException;
import java.io.IOException;

public class SimpleNoParent extends SimpleTagSupport {
    private boolean called;

    public SimpleNoParent() {
        super();
    }

    public void setParent(JspTag parent) {
        this.called = true;
        super.setParent(parent);
    }

    public void doTag() throws JspException, IOException {
        JspTestUtil.debug("[SimpleNoParent] in doTag()");
        if(this.called) {
            this.getJspContext().getOut().println("Test FAILED. setParent() is unexpectedly called.");
        } else {
            this.getJspContext().getOut().println("Test PASSED. setParent() is not called.");
        }
        this.called = false;
    }
}
