/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.ts.tests.jsp.spec.el.jsp;

import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import java.io.IOException;

public class ELDeferredMethodValueTag extends SimpleTagSupport {

    private MethodExpression litExpr;
    private MethodExpression poundExpr;

    public void setLitExpr(MethodExpression litExpr) {
        this.litExpr = litExpr;
    }

    public void setPoundExpr(MethodExpression poundExpr) {
        this.poundExpr = poundExpr;
    }

    public void doTag() throws JspException, IOException {
        ELContext elContext = getJspContext().getELContext();
        JspWriter out = getJspContext().getOut();

        try {
            litExpr.getMethodInfo(elContext);
            out.println("getMethodInfo() called for literal expression");
            poundExpr.getMethodInfo(elContext);
            out.println("Test PASSED."); 
        } catch (Throwable t) {
            JspTestUtil.handleThrowable(t, out, "ELDeferredMethodValueTag");
        }
    }
}
