<%--
   Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
   SUN PROPRIETARY/CONFIDENTIAL.  Use is subject license terms.
--%>

<%@ page import="com.sun.ts.tests.jsp.common.util.JspTestUtil,
             javax.el.ValueExpression,
             javax.el.ELContext"%>
<%@ page contentType="text/plain" %>

<%!
private static final String VARIABLE_EXPR = "${foo}";
private static final String EXPECTED_VALUE = "bar";
%>

<% 
    if (pageContext != null) {
        ELContext elContext = pageContext.getELContext();

        if (elContext != null) {
            JspApplicationContext jaContext = 
                    JspFactory.getDefaultFactory().getJspApplicationContext(
                    pageContext.getServletContext());
            if (jaContext != null) {
                
                try {

                    // parse the value expression
                    ValueExpression vexp = 
                            jaContext.getExpressionFactory().createValueExpression(
                            elContext, VARIABLE_EXPR, VARIABLE_EXPR.getClass());

                    if (vexp != null) {
                
                        // set a value for it 
                        out.println("Setting value for value expression");
                        vexp.setValue(elContext, EXPECTED_VALUE);

                        Class expectedClass = vexp.getExpectedType();
                        Object obj = vexp.getValue(elContext);
                        
                        if (!(expectedClass.isInstance(obj))) {
                            out.println("Test FAILED. Expected type = " + expectedClass.getName());
                            out.println("Got type = " + obj.getClass().getName()); 
                        }

                        out.println("Test PASSED");
                    } 
                    else 
                        out.println("Test FAILED. Null value returned for expression.");
                 } catch (Throwable t) {
                    JspTestUtil.handleThrowable(t, out, "CreateValueExpressionTest");
                 }
            }
            else
                out.println("Test FAILED. Unable to obtain JspApplicationContext");
        }
        else
            out.println("Test FAILED. Unable to obtain ELContext");
    } 
    else 
        out.println("Test FAILED.  Unable to obtain PageContext.");
%>
