/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.File;
import java.util.StringTokenizer;
import javasoft.sqe.apiCheck.VectorString;

class PackageSet {
    VectorString indepth = new VectorString();
    VectorString exdepth = new VectorString();
    VectorString inplain = new VectorString();
    VectorString explain = new VectorString();

    PackageSet() {
    }

    PackageSet(String inpacks, String expacks) {
        String sep = File.pathSeparator;
        if (inpacks != null) {
            int op = 43;
            StringTokenizer st = new StringTokenizer(inpacks, sep + " +-", true);
            while (st.hasMoreElements()) {
                String s = (String)st.nextElement();
                if (s.equals(sep) || s.equals(" ") || s.equals("+")) {
                    op = 43;
                    continue;
                }
                if (s.equals("-")) {
                    op = 45;
                    continue;
                }
                if (op == 43) {
                    this.Add(s, true);
                    continue;
                }
                this.Sub(s, true);
            }
        }
        if (expacks != null) {
            StringTokenizer st = new StringTokenizer(expacks, sep + " +", false);
            while (st.hasMoreElements()) {
                String s = (String)st.nextElement();
                this.Sub(s, true);
            }
        }
    }

    boolean IsEmpty() {
        return this.indepth.isEmpty() && this.inplain.isEmpty();
    }

    void Add(String s) {
        this.Add(s, false);
    }

    void Add(String s, boolean depth) {
        if (!s.endsWith(".")) {
            s = s + '.';
        }
        if (depth) {
            this.indepth.addElement(s);
        } else {
            this.inplain.addElement(s);
        }
    }

    void Sub(String s) {
        this.Sub(s, false);
    }

    void Sub(String s, boolean depth) {
        if (!s.endsWith(".")) {
            s = s + '.';
        }
        if (depth) {
            this.exdepth.addElement(s);
        } else {
            this.explain.addElement(s);
        }
    }

    boolean Under(String s, VectorString plain, VectorString depth) {
        if (!s.endsWith(".")) {
            s = s + '.';
        }
        String x = plain.First();
        while (x != null) {
            if (x.equals(s)) {
                return true;
            }
            x = plain.Next();
        }
        x = depth.First();
        while (x != null) {
            if (s.startsWith(x)) {
                return true;
            }
            x = depth.Next();
        }
        return false;
    }

    boolean AboveUnder(String s, VectorString plain, VectorString depth) {
        if (s.length() == 0) {
            return true;
        }
        if (!s.endsWith(".")) {
            s = s + '.';
        }
        String x = plain.First();
        while (x != null) {
            if (x.startsWith(s)) {
                return true;
            }
            x = plain.Next();
        }
        x = depth.First();
        while (x != null) {
            if (x.startsWith(s) || s.startsWith(x)) {
                return true;
            }
            x = depth.Next();
        }
        return false;
    }

    boolean OnPath(String s) {
        if (this.Under(s, this.explain, this.exdepth)) {
            return false;
        }
        return this.inplain.isEmpty() && this.indepth.isEmpty() ? true : this.AboveUnder(s, this.inplain, this.indepth);
    }

    boolean InPath(String s) {
        if (this.Under(s, this.explain, this.exdepth)) {
            return false;
        }
        return this.inplain.isEmpty() && this.indepth.isEmpty() ? true : this.Under(s, this.inplain, this.indepth);
    }

    public String toString() {
        String s = "";
        String x = this.indepth.First();
        while (x != null) {
            if (s.length() != 0) {
                s = s + '+';
            }
            s = s + x.substring(0, x.length() - 1);
            x = this.indepth.Next();
        }
        x = this.exdepth.First();
        while (x != null) {
            s = s + "-" + x.substring(0, x.length() - 1);
            x = this.exdepth.Next();
        }
        return s;
    }
}

