/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: HttpRequestTestServlet.java 62571 2011-04-18 20:58:13Z kgrucci $
 */

/*
 * $URL: https://adc4110351.us.oracle.com/svn/spider/branches/cts/8.0/src/com/sun/ts/tests/servlet/api/common/request/HttpRequestTestServlet.java $ $LastChangedDate: 2011-04-18 13:58:13 -0700 (Mon, 18 Apr 2011) $
 */

package com.sun.ts.tests.servlet.api.common.request;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HttpRequestTestServlet extends HttpServlet {

    private static final String TEST_HEADER = "testname";

    private static final Class[] HTTP_TEST_ARGS = {
        PrintWriter.class,
        HttpServletRequest.class,
        HttpServletResponse.class
    };

    private static final Class[] TEST_ARGS = {
        PrintWriter.class,
        ServletRequest.class,
        ServletResponse.class,
    };

    private static final Class[][] ALL_TYPES = {
        TEST_ARGS,
        HTTP_TEST_ARGS
    };

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse)
      throws ServletException, IOException {
        String test = servletRequest.getParameter(TEST_HEADER).trim();
        servletRequest.setAttribute("servletContext", getServletConfig().getServletContext());
        PrintWriter pw = servletResponse.getWriter();
        Method method = null;
        for (int i = 0; i < ALL_TYPES.length; i++) {
            try {
                method = RequestTests.class.getDeclaredMethod(test, ALL_TYPES[i]);
                break;
            } catch (NoSuchMethodException nsme) {
                ; //do nothing
            }
        }

        if (method != null) {
            invokeTest(method, new Object[] { pw, servletRequest, servletResponse });
        } else {
            throw new ServletException("No such test: " + test);
        }

    }

    private void invokeTest(Method toBeInvoked, Object[] paramValues)
      throws ServletException {
        try {
            toBeInvoked.invoke(null, paramValues);
        } catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        } catch (Throwable t) {
            throw new ServletException("Error executing test: " + toBeInvoked.getName(), t);
        }
    }
}
