/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: SetHeaderResponseFilter.java 62895 2011-05-27 14:27:42Z djiao $
 */

package com.sun.ts.tests.servlet.api.javax_servlet.dofilter;


import com.sun.ts.tests.servlet.common.util.ServletTestUtil;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;


public final class SetHeaderResponseFilter implements Filter {


    // The filter configuration object we are associated with.  If this value
    // is null, this filter instance is not currently configured.
    private FilterConfig filterConfig = null;


    public void doFilter(ServletRequest request, ServletResponse response,
                         FilterChain chain) throws IOException, ServletException {

        PrintWriter pw = response.getWriter();

        ServletTestUtil.printResult(pw, "in SetHeaderResponseFilter");

        chain.doFilter(request, response);
        
        pw.write("modifiedHeader");
    }


    // Remove the filter configuration object for this filter.
    public void destroy() {
    }


    //  initialize the filter configuration object for this filter.
    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
    }
}

