/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.scinitializer.getfilterregistrations;

import java.io.IOException;
import javax.servlet.*;
import javax.servlet.annotation.WebFilter;

@WebFilter(urlPatterns = {"/foo"})
public final class TestFilter implements Filter {

        // The filter configuration object we are associated with.  If this value
        // is null, this filter instance is not currently configured.
        private FilterConfig filterConfig;

        public void doFilter(ServletRequest request, ServletResponse response,
                FilterChain chain) throws IOException, ServletException {

                if (filterConfig == null) {
                        System.out.println("doFilter of TestFilter was called but this filter instance is not currently configured");
                } else {
                        System.out.println("TEST_FILTER_INVOKED");
                }

                chain.doFilter(request, response);
        }

        // Remove the filter configuration object for this filter.
        public void destroy() {
        }

        //  initialize the filter configuration object for this filter.
        public void init(FilterConfig filterConfig) {
                this.filterConfig = filterConfig;
        }
}
