/*
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */

package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext30;


import com.sun.ts.tests.servlet.common.util.StaticLog;

import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;

public final class AddSCAttributeListenerString
    implements ServletContextAttributeListener {

    // Public Methods

    public void attributeAdded(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeAddedString:" + event.getName() + "," + event.getValue());
    }


    public void attributeRemoved(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeRemovedString:" + event.getName() + "," + event.getValue());
    }


    public void attributeReplaced(ServletContextAttributeEvent event) {
        StaticLog.add("SCAttributeReplacedString:" + event.getName() + "," + event.getValue());
    }

}
