/*
 * Copyright (c) 2012, 2014, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id$
 */
package com.sun.ts.tests.servlet.api.javax_servlet.servletcontext302;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletContextEvent;

import com.sun.ts.tests.servlet.api.javax_servlet.servletcontext301.AddGenericEventListenerClass;

public class TestListener implements ServletContextListener {

    /**
     * Receives notification that the web application initialization
     * process is starting.
     *
     * @param sce The servlet context event
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();

        /*
         * Negative tests for
         *     - addListener
         */
        Boolean listener_test = false;
        String LISTENER_TEST = "LISTENER_TEST";

        try {
            context.addListener(AddGenericEventListenerClass.class.getName());
        } catch (IllegalArgumentException ex) {
            listener_test = true;
        }
        context.setInitParameter(LISTENER_TEST, listener_test.toString());
    }

    /**
     * Receives notification that the servlet context is about to be shut down.
     *
     * @param sce The servlet context event
     */
    public void contextDestroyed(ServletContextEvent sce) {
    // Do nothing
    }
}
