/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.asynccontext;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public final class ACListener implements AsyncListener {

    public ACListener() throws IOException {
    }

    public void onError(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onError method of ACListener");
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onStartAsync method of ACListener");
    }

    public void onComplete(AsyncEvent event) throws IOException {
        // commented out as part of bug fix for: 
        // https://bug.oraclecorp.com/pls/bug/webbug_edit.edit_info_top?rptno=19258007
        //event.getAsyncContext().getResponse().getWriter().println("in onComplete method of ACListener");
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        event.getAsyncContext().getResponse().getWriter().println("in onTimeout method of ACListener");
    }
}
