/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.api.javax_servlet_http.servletcontext303;

import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import com.sun.ts.tests.servlet.common.util.ServletTestUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TestServlet extends HttpTCKServlet {

    public void negativeaddHListenerClassTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.HSessionListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
            }
            exf.printStackTrace(pw);
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddHListenerStringTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.HSessionListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
            }
            exf.printStackTrace(pw);
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddHAListenerClassTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener(com.sun.ts.tests.servlet.api.common.sharedfiles.HSessionAttributeListener.class);
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
            }
            exf.printStackTrace(pw);
            ServletTestUtil.printResult(pw, passed);
        }
    }

    public void negativeaddHAListenerStringTest(HttpServletRequest request,
            HttpServletResponse response)
            throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        Boolean passed = false;

        try {
            getServletContext().addListener("com.sun.ts.tests.servlet.api.common.sharedfiles.HSessionAttributeListener");
        } catch (Exception exf) {
            if (exf instanceof java.lang.IllegalStateException) {
                passed = true;
                pw.print("Expected IllegalStateException is thrown: ");
            } else {
                pw.print("Unexpected Exception type is thrown: ");
            }
            exf.printStackTrace(pw);
            ServletTestUtil.printResult(pw, passed);
        }
    }
}
