/*
 * Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.pluggability.api.javax_servlet.servletresponsewrapper30;

import java.io.PrintWriter;
import com.sun.javatest.Status;
import com.sun.ts.tests.servlet.common.client.AbstractUrlClient;

public class URLClient extends AbstractUrlClient {

    private static final String CONTEXT_ROOT =
            "/servlet_plu_servletresponsewrapper30_web";

    /**
     * Entry point for different-VM execution.  It should delegate to method
     * run(String[], PrintWriter, PrintWriter), and this method should not
     * contain any test configuration.
     */
    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, new PrintWriter(System.out),
                new PrintWriter(System.err));
        s.exit();
    }

    /**
     * Entry point for same-VM execution. In different-VM execution, the
     * main method delegates to this method.
     */
    public Status run(String args[], PrintWriter out, PrintWriter err) {
        setContextRoot(CONTEXT_ROOT);

        return super.run(args, out, err);
    }

    /*
     * @class.setup_props: webServerHost;
     *			   webServerPort;
     *			   ts_home;
     */

    /* Run test */
    /*
     * @testName:  isWrapperForTest
     *
     * @assertion_ids: Servlet:JAVADOC:731; Servlet:JAVADOC:732;
     *
     * @test_Strategy: Create a Servlets isWrapperForTest;
     *                 In the servlet, wrap the Response a few time and in different ways;
     *                 verifies the following works:
     *                 - javax.servlet.ServletResponseWrapper.isWrapperFor(ServletResponse)
     *                 - javax.servlet.ServletResponseWrapper.isWrapperFor(Class)
     */
    public void isWrapperForTest() throws Fault {
        TEST_PROPS.setProperty(REQUEST,
                "GET " + getContextRoot() + "/IsWrapperForTest  HTTP/1.1");
        TEST_PROPS.setProperty(UNEXPECTED_RESPONSE_MATCH, "Test Failed");
        invoke();
    }
}
