/*
 * Copyright (c) 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id:$
 */
package com.sun.ts.tests.servlet.spec.annotationservlet.weblistener;

import java.util.ArrayList;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.annotation.WebListener;

@WebListener(value = "ServletContextAttributeListener")
public final class SCAttributeListener implements ServletContextAttributeListener {

    public void attributeAdded(ServletContextAttributeEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SCAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("SCAAdded:" + event.getName() + "," + event.getValue());
        event.getServletContext().setAttribute("SCAList", al);
    }

    public void attributeRemoved(ServletContextAttributeEvent event) {
        ArrayList al = null;
        al = (ArrayList) event.getServletContext().getAttribute("SCAList");
        if (al == null) {
            al = new ArrayList();
        }
        al.add("SCARemoved:" + event.getName() + "," + event.getValue());
        event.getServletContext().setAttribute("SCAList", al);
    }

    public void attributeReplaced(ServletContextAttributeEvent event) {
     }
}
